(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    630580,      16316]
NotebookOptionsPosition[    612045,      16001]
NotebookOutlinePosition[    612515,      16018]
CellTagsIndexPosition[    612472,      16015]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Bicentric trapezoids", "Title",
 CellChangeTimes->{{3.947133122765019*^9, 3.947133141273266*^9}, 
   3.947147906503248*^9, {3.947481336744753*^9, 3.947481338032559*^9}, {
   3.947482272199051*^9, 3.947482274311268*^9}, {3.94749391578257*^9, 
   3.9474939175186405`*^9}, {3.9474950154605656`*^9, 
   3.947495024420042*^9}},ExpressionUUID->"29001ab6-6556-7b4b-a45f-\
7ca429ca0ceb"],

Cell["\<\
This Notebook contains the proofs for the results about bicentric trapezoids \
in the paper \"More Relationships between a Central Quadrilateral and its \
Reference Quadrilateral\[CloseCurlyDoubleQuote]
by Stanley Rabinowitz and Ercole Suppa, submitted to the International \
Journal of Computer Discovered Mathematics (http://www.journal-1.eu/) in \
February 2025.

This Notebook is Copyright \[Copyright] February 2025 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and Ercole Suppa (ercolesuppa@gmail.com) and is \
published with open access . 
This Notebook is distributed under the terms of the Creative Commons \
Attribution License which permits any use, distribution, and reproduction in \
any medium, provided the original author and the source are credited. 
The baricentricas package must be loaded before running this Notebook . It \
can be obtained from http://garciacapitan.epizy.com/baricentricas/.\
\>", "Text",
 CellChangeTimes->{{3.947134015183899*^9, 3.947134126514601*^9}, {
  3.947134165027289*^9, 3.947134216283169*^9}, {3.947146196077376*^9, 
  3.947146197937656*^9}, {3.947147714654799*^9, 3.947147721422184*^9}, {
  3.947147756182218*^9, 3.947147799085409*^9}, {3.947147829468706*^9, 
  3.947147925478302*^9}, {3.947481344697075*^9, 3.947481347432724*^9}, {
  3.947482281782265*^9, 3.947482284055073*^9}, {3.947493923358579*^9, 
  3.947493924694851*^9}, {3.947495028589079*^9, 
  3.9474950356766624`*^9}},ExpressionUUID->"08758b0a-705f-b842-b1d6-\
6a28a79b6218"],

Cell[CellGroupData[{

Cell["Setup", "Section",
 CellChangeTimes->{{3.94550589477663*^9, 3.9455059090976067`*^9}, {
  3.947131190260437*^9, 
  3.947131192227951*^9}},ExpressionUUID->"5e4c6aa2-710c-4599-941e-\
5f13e499af78"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"<<", "baricentricas.m"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", ">", "0"}], ",", 
     RowBox[{"b", ">", "0"}], ",", 
     RowBox[{"c", ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "b", "-", "c"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"a", "+", "c", "-", "b"}], ">", "0"}], ",", 
     RowBox[{
      RowBox[{"b", "+", "c", "-", "a"}], ">", "0"}]}], "}"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.945504565162958*^9, 3.94550458198252*^9}, {
   3.9455170892604294`*^9, 3.945517091156999*^9}, {3.946437513579389*^9, 
   3.946437514387348*^9}, {3.946437922994858*^9, 3.946437998083948*^9}, {
   3.947131229988783*^9, 3.9471312337408752`*^9}, {3.94713126947538*^9, 
   3.947131271053065*^9}, {3.9471314397563486`*^9, 3.947131528028438*^9}, {
   3.947131689741032*^9, 3.947131695924305*^9}, {3.947131733918829*^9, 
   3.947131775067988*^9}, 3.94713185451009*^9, {3.947132455427481*^9, 
   3.947132456035076*^9}, {3.947133799219084*^9, 3.947133799613205*^9}, {
   3.947481378154803*^9, 3.947481389864706*^9}, 3.94749400024761*^9, {
   3.947495050524956*^9, 3.9474950712444*^9}, {3.947749243751951*^9, 
   3.947749245911686*^9}},ExpressionUUID->"0ab55ca4-7597-488a-96c3-\
e391e6fbeef1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ptD", "=", 
  RowBox[{"SimetriaAxial", "[", 
   RowBox[{"ptA", ",", 
    RowBox[{"Mediatriz", "[", 
     RowBox[{"ptB", ",", "ptC"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->
  "In[154]:=",ExpressionUUID->"f08a65d6-2a9b-5346-8b33-49696673696b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["a", "2"]}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b", "-", "c"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "c"}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["b", "2"]}], "+", 
    SuperscriptBox["c", "2"]}]}], "}"}]], "Output",
 CellChangeTimes->{3.9474950920449715`*^9, 3.9474951743014297`*^9, 
  3.947495630630438*^9, 3.947586642534031*^9},
 CellLabel->
  "Out[154]=",ExpressionUUID->"062b5b80-f103-7c4f-ac50-c589f2f202c5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"ptI1", "=", 
   RowBox[{"Medio", "[", 
    RowBox[{
     RowBox[{"Medio", "[", 
      RowBox[{"ptA", ",", "ptD"}], "]"}], ",", 
     RowBox[{"Medio", "[", 
      RowBox[{"ptB", ",", "ptC"}], "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ptI2", "=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"ptB", ",", "ptI"}], "]"}], ",", 
     RowBox[{"Mediatriz", "[", 
      RowBox[{"ptB", ",", "ptC"}], "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Factor", "[", 
  RowBox[{"Cross", "[", 
   RowBox[{"ptI1", ",", "ptI2"}], "]"}], "]"}]}], "Input",
 CellChangeTimes->{{3.9474951626127415`*^9, 3.94749516905204*^9}, {
  3.9474952038846893`*^9, 3.947495208340172*^9}},
 CellLabel->
  "In[155]:=",ExpressionUUID->"e93692f2-d74e-9345-bba6-3ddc32f5e013"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"b", "-", "c"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"b", "+", "c"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"2", " ", "a", " ", "c"}], "-", 
      SuperscriptBox["c", "2"]}], ")"}]}], ",", 
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"2", " ", "a", " ", "c"}], "-", 
      SuperscriptBox["c", "2"]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a", "2"], "+", 
      SuperscriptBox["b", "2"], "-", 
      RowBox[{"2", " ", "a", " ", "c"}], "-", 
      SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.947495157961611*^9, 3.9474951651943264`*^9}, 
   3.947495209067501*^9, 3.9474954288332863`*^9, 3.947495630636423*^9, 
   3.9475866425459614`*^9},
 CellLabel->
  "Out[157]=",ExpressionUUID->"221f3288-9f9f-cc48-8020-2043eec504ff"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"q", ",", "r"}], "}"}], "/.", 
  RowBox[{
   RowBox[{"Quiet", "[", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Cross", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"p", ",", "q", ",", "r"}], "}"}], ",", "ptD"}], "]"}], "==", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"p", ",", "q", ",", "r"}], "}"}]}], "]"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.947495346747999*^9, 3.947495405828043*^9}, {
  3.947495464995861*^9, 3.9474954651237774`*^9}},
 CellLabel->
  "In[158]:=",ExpressionUUID->"032fb70e-8218-4041-b370-2b5bda03807a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", "p"}], 
     SuperscriptBox["a", "2"]]}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", "p"}], 
     SuperscriptBox["a", "2"]]}]}], "}"}]], "Output",
 CellChangeTimes->{{3.947495324677679*^9, 3.947495431592413*^9}, 
   3.947495465775776*^9, 3.9474956306454735`*^9, 3.9475866425838604`*^9},
 CellLabel->
  "Out[158]=",ExpressionUUID->"78c19a84-1ce3-f443-841c-9f1a0fd48399"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "condition", " ", "for", " ", "ABCD", " ", "to", " ", "be", " ", "an", 
     " ", "isosceles", " ", "trapezoid"}], ",", " ", 
    RowBox[{"where", " ", "D", 
     RowBox[{"(", 
      RowBox[{"p", ":", "q", ":", "r"}], ")"}]}]}], " ", "*)"}], " ", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"bitrap", "=", 
    RowBox[{
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "2"], "+", 
       SuperscriptBox["b", "2"], "-", 
       RowBox[{"2", " ", "a", " ", "c"}], "-", 
       SuperscriptBox["c", "2"]}], "==", "0"}], "&&", 
     RowBox[{"b", ">", "c"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], "q"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "p"}]}], "==", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["a", "2"], "r"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], "+", 
          SuperscriptBox["c", "2"]}], ")"}], "p"}]}], "==", "0"}]}]}], 
   ";"}]}]], "Input",
 CellChangeTimes->{{3.947495490756136*^9, 3.947495494700245*^9}, {
  3.9474955292789135`*^9, 3.9474955505402813`*^9}, {3.947496156539339*^9, 
  3.9474961582187824`*^9}},
 CellLabel->
  "In[159]:=",ExpressionUUID->"d865d4d2-1c7e-a94b-bb8d-af4ca1b1133d"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Support routines", "Section",
 CellChangeTimes->{{3.850468990902514*^9, 3.850469001252577*^9}, {
  3.850469071318833*^9, 3.850469073637095*^9}, {3.850469177050805*^9, 
  3.85046919499736*^9}},ExpressionUUID->"cf60f297-bbcd-8748-b453-\
e7118b4e0a98"],

Cell[CellGroupData[{

Cell["QAP centers", "Subsection",
 CellChangeTimes->{{3.945853740709931*^9, 3.945853743438184*^9}, {
  3.9464394595455627`*^9, 
  3.9464394652171745`*^9}},ExpressionUUID->"c8cca55e-04f1-8f4a-b670-\
3c3179eed91e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP", "=", 
   RowBox[{"<|", 
    RowBox[{
     RowBox[{"1", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ",", 
        RowBox[{"p", "+", 
         RowBox[{"2", " ", "q"}], "+", "r"}], ",", 
        RowBox[{"p", "+", "q", "+", 
         RowBox[{"2", " ", "r"}]}]}], "}"}]}], ",", 
     RowBox[{"2", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", " ", "SB"}], "-", 
           RowBox[{"r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "SA"}], "+", 
           RowBox[{"r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "SA"}], "-", 
           RowBox[{"q", " ", "SB"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"3", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}]}], 
          ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", 
              RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"4", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", "SA"}], "-", 
           RowBox[{"2", " ", "p", " ", "q", " ", "SA"}], "-", 
           RowBox[{"2", " ", "p", " ", "r", " ", "SA"}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}]}], ")"}]}],
         ",", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p"}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q"}], "-", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}], 
             ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"5", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"6", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"q", " ", 
                SuperscriptBox["SB", "2"]}], "-", 
               RowBox[{"r", " ", 
                SuperscriptBox["SC", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"q", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"p", " ", 
                SuperscriptBox["SA", "2"]}], "-", 
               RowBox[{"r", " ", 
                SuperscriptBox["SC", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "-", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                SuperscriptBox["S", "2"]}], "-", 
               RowBox[{"p", " ", 
                SuperscriptBox["SA", "2"]}], "-", 
               RowBox[{"q", " ", 
                SuperscriptBox["SB", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"7", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SB", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 SuperscriptBox["SB", "2"], "+", 
                 RowBox[{"2", " ", "SB", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"2", " ", "SB", " ", "SC"}], "+", 
                 SuperscriptBox["SC", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
           RowBox[{"q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"3", " ", "r", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"r", " ", "SC", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "SA"}], "+", "SC"}], ")"}]}], "+", 
              RowBox[{"p", " ", "SA", " ", 
               RowBox[{"(", 
                RowBox[{"SA", "+", 
                 RowBox[{"2", " ", "SC"}]}], ")"}]}], "+", 
              RowBox[{"2", " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SA", " ", "SC"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
           RowBox[{"r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"3", " ", "q", " ", 
               SuperscriptBox["S", "2"]}], "+", 
              RowBox[{"q", " ", "SB", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "SA"}], "+", "SB"}], ")"}]}], "+", 
              RowBox[{"p", " ", "SA", " ", 
               RowBox[{"(", 
                RowBox[{"SA", "+", 
                 RowBox[{"2", " ", "SB"}]}], ")"}]}], "+", 
              RowBox[{"2", " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["S", "2"]}], "+", 
                 RowBox[{"SA", " ", "SB"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}],
        "}"}]}], ",", 
     RowBox[{"8", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "p"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["b", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "p"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["c", "2"], " ", "q"}], "+", 
            RowBox[{"4", " ", "r", " ", 
             SuperscriptBox["S", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}]}], "}"}]}],
      ",", 
     RowBox[{"9", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p", " ", "q"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["q", "2"]}], "+", 
                 RowBox[{"3", " ", "p", " ", "r"}], "+", 
                 RowBox[{"q", " ", "r"}], "-", 
                 SuperscriptBox["r", "2"]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "p", " ", "q"}], "-", 
                 SuperscriptBox["q", "2"], "+", 
                 RowBox[{"2", " ", "p", " ", "r"}], "+", 
                 RowBox[{"q", " ", "r"}], "+", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "q"}], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"4", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "q"}], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "-", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"5", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"3", " ", "p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "8"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "8"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", 
                 RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"p", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
              "-", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"p", " ", 
                  SuperscriptBox[
                   RowBox[{"(", 
                    RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"8", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"4", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["c", "6"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", 
                   SuperscriptBox["p", "2"]}], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "q", " ", 
                  SuperscriptBox["r", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"12", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"9", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["q", "3"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"12", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"9", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"13", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "2"]}], " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "r"}], "-", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", 
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"2", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"-", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "6"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["p", "2"], "-", 
                 RowBox[{"2", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], 
              "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["c", "6"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", "q", " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"5", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "-", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["q", "2"], " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
                 RowBox[{"p", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "3"}], " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", 
                  SuperscriptBox["q", "3"], " ", "r"}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  SuperscriptBox["r", "3"]}], "+", 
                 RowBox[{"8", " ", 
                  SuperscriptBox["p", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"-", "2"}], " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"8", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    SuperscriptBox["r", "3"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "3"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"9", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"12", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["c", "2"]}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "8"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["q", "2"]}]}], ")"}], " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "2"]}], " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "+", "q"}], ")"}]}]}], ")"}], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", "r"}], "-", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "6"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"6", " ", "q", " ", "r"}], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}],
            "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["c", "6"]}], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["p", "2"]}], "+", 
                 RowBox[{"2", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "6"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"2", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"3", " ", 
                  SuperscriptBox["q", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"5", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["p", "4"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", "q"}], "-", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"6", " ", 
                  SuperscriptBox["q", "2"], " ", 
                  SuperscriptBox["r", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{"3", " ", 
                  SuperscriptBox["p", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"4", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"3", " ", "q", " ", "r"}], "+", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "+", 
                    RowBox[{"4", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"6", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"13", " ", "q", " ", "r"}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "q", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], "2"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "4"}], " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"2", " ", "q"}], "+", 
                    RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "2"]}], "+", 
                    RowBox[{"q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"8", " ", 
                  SuperscriptBox["p", "2"], " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "3"], " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", 
                    RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
                 RowBox[{"2", " ", "q", " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "-", 
                    SuperscriptBox["r", "2"]}], ")"}]}], "+", 
                 RowBox[{"p", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "3"], "+", 
                    RowBox[{"8", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"6", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "-", 
                    RowBox[{"2", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"6", " ", 
                  SuperscriptBox["p", "3"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{"q", "+", "r"}], ")"}]}], "-", 
                 RowBox[{"2", " ", 
                  SuperscriptBox["q", "2"], " ", "r", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    SuperscriptBox["q", "2"], "-", 
                    RowBox[{"2", " ", "q", " ", "r"}], "-", 
                    RowBox[{"3", " ", 
                    SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
                 RowBox[{
                  SuperscriptBox["p", "2"], " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{"12", " ", 
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"13", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"6", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
                 RowBox[{"p", " ", "q", " ", 
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"3", " ", 
                    SuperscriptBox["q", "3"]}], "+", 
                    RowBox[{
                    SuperscriptBox["q", "2"], " ", "r"}], "+", 
                    RowBox[{"9", " ", "q", " ", 
                    SuperscriptBox["r", "2"]}], "+", 
                    RowBox[{"13", " ", 
                    SuperscriptBox["r", "3"]}]}], ")"}]}]}], ")"}]}]}], 
             ")"}]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"10", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"11", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"12", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
          ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", "q", " ", "SB"}], "+", 
           RowBox[{"p", " ", "r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{"p", " ", "q", " ", "SA"}], "+", 
           RowBox[{"q", " ", "r", " ", "SC"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r", " ", "SA"}], "+", 
           RowBox[{"q", " ", "r", " ", "SB"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "2"]}], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", "q", " ", 
            SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"13", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"14", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "r"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"5", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", "SA"}], "+", 
         RowBox[{"2", " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "q"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "r"}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "-", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", "SB"}], "+", 
         RowBox[{"2", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "-", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}]}], ")"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"10", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"9", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"5", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"9", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}], " ", "SC"}]}]}], "}"}]}], 
     ",", 
     RowBox[{"15", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "q"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", 
               RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"q", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{"q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["q", "2"]}], "+", 
               RowBox[{"5", " ", "q", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"], " ", "r"}], "+", 
            RowBox[{"q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"5", " ", "q", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["p", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "q", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["q", "2"]}], "+", 
               RowBox[{"22", " ", "q", " ", "r"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "p"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"5", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"5", " ", "p", " ", "r"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"5", " ", "p", " ", "r"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["q", "4"]}], "+", 
            RowBox[{"10", " ", 
             SuperscriptBox["q", "3"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"2", " ", "p", " ", "r", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"22", " ", "p", " ", "r"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["q", "2"]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               SuperscriptBox["q", "2"]}], ")"}], " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"5", " ", "p"}], "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"5", " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"5", " ", "p", " ", "q"}], "+", 
               SuperscriptBox["q", "2"]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"5", " ", "p", " ", "q"}], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["q", "2"]}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}]}], ")"}], " ", "r"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"9", " ", 
                SuperscriptBox["p", "2"]}], "+", 
               RowBox[{"22", " ", "p", " ", "q"}], "+", 
               RowBox[{"9", " ", 
                SuperscriptBox["q", "2"]}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"10", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "4"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"16", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], ",", 
        RowBox[{"r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"17", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"q", " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{"p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["q", "2"], "+", 
              SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "r", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], "2"]}], "-", 
           RowBox[{"q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], "2"]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["p", "2"], "+", 
              SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"18", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"19", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"20", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"21", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"22", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"3", " ", "p", " ", "r"}], "-", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "p"}], " ", "q"}], "+", 
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"23", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
         RowBox[{"p", " ", "q", " ", "SB"}], "+", 
         RowBox[{"p", " ", "r", " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
         RowBox[{"p", " ", "q", " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
         RowBox[{"p", " ", "r", " ", "SA"}], "+", 
         RowBox[{"q", " ", "r", " ", "SB"}]}]}], "}"}]}], ",", 
     RowBox[{"24", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", "SB", " ", 
          "SC"}], "-", 
         RowBox[{"4", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "SC"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], ")"}], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", "SC"}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{"r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", "SA", " ", 
          "SC"}], "-", 
         RowBox[{"4", " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "SC"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], ")"}], 
          " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", "SC"}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", "SA", " ", 
          "SB"}], "-", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", "SA"}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}], "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox[
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], "2"], " ", "SC"}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"25", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"2", " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"26", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "q", " ", "r"}], "+", 
           RowBox[{"5", " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "r"}], "+", 
           RowBox[{"5", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "p", " ", "q"}], "+", 
           RowBox[{"5", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q", "+", "r"}], ")"}]}]}], ")"}]}]}], "}"}]}],
      ",", 
     RowBox[{"27", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["p", "4"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "3"], " ", "q"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"p", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{"q", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "3"]}], " ", "q"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           SuperscriptBox["q", "4"], "+", 
           RowBox[{
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"q", " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["p", "3"], " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["p", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{"p", " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{"2", " ", "p", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{"2", " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           SuperscriptBox["r", "4"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"28", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "4"]}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SuperscriptBox["p", "2"]}], "+", 
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["p", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
              RowBox[{
               SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["b", "2"], "-", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", "r"}]}], 
             ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"5", " ", 
               SuperscriptBox["p", "2"]}], "+", 
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "4"]}], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["q", "2"]}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["q", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["c", "4"], " ", "p", " ", "q"}], "+", 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "+", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", "r"}], "+", 
              RowBox[{
               SuperscriptBox["a", "4"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", "p", " ", "q"}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["q", "2"]}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"3", " ", "q", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["b", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "q"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", 
              SuperscriptBox["r", "2"], " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "q", "+", 
                RowBox[{"2", " ", "r"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 RowBox[{"(", 
                  RowBox[{
                   SuperscriptBox["a", "2"], "-", 
                   SuperscriptBox["b", "2"]}], ")"}], " ", "p", " ", "q"}], 
                "+", 
                RowBox[{
                 SuperscriptBox["b", "4"], " ", "p", " ", "r"}], "+", 
                RowBox[{
                 SuperscriptBox["a", "4"], " ", "q", " ", "r"}]}], ")"}]}], 
             ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
           RowBox[{"p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"3", " ", "p", " ", "r"}], "+", 
              RowBox[{"3", " ", "q", " ", "r"}], "+", 
              RowBox[{"5", " ", 
               SuperscriptBox["r", "2"]}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", 
               SuperscriptBox["c", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
       "}"}]}], ",", 
     RowBox[{"29", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["a", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "3"], " ", "r"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["p", "2"]}], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"30", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "q"}], ")"}], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", "r"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "-", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"q", "-", 
              RowBox[{"3", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "q"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "p"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", 
              RowBox[{"3", " ", "r"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "q"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "-", "r"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"p", " ", "q"}], "-", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], " ", "p"}], "+", "q"}], ")"}], " ", "r", 
            " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "-", 
              RowBox[{"3", " ", "q"}]}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "p"}], "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "2"}], " ", "p", " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "p", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"2", " ", "p", " ", "r"}], "+", 
              RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "p"}], " ", "q"}], "+", 
              RowBox[{"p", " ", "r"}], "+", 
              RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}]}], 
       "}"}]}], ",", 
     RowBox[{"31", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", " ", 
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["p", "2"], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}], ",", 
        RowBox[{"q", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           SuperscriptBox["q", "2"], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}], "+", 
           SuperscriptBox["r", "2"]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"32", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "+", 
         RowBox[{"2", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "+", 
         RowBox[{"2", " ", "p", " ", "q", " ", 
          SuperscriptBox["r", "2"], " ", 
          SuperscriptBox["S", "2"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SC"}]}]}], "}"}]}],
      ",", 
     RowBox[{"33", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SB"}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SB", " ", 
             "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SC"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"q", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA", " ", 
             "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SA"}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          SuperscriptBox["r", "2"], " ", "SB"}], "+", 
         RowBox[{"p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{"3", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", "SA", " ", 
             "SB"}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"34", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}]}], 
           ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "p"}], "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"4", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"4", " ", "q"}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{"3", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "p"}], "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{"3", " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"35", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"15", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "3"], " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "3"], " ", "r"}], "-", 
            RowBox[{"12", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"5", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["c", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"15", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"15", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"12", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "3"], " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"5", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["p", "2"]}], " ", "q"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"15", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"8", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"15", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"5", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r"}], "-", 
            RowBox[{"5", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"12", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "3"]}], "+", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"36", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["p", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["c", "2"]}], " ", "q"}], "-", 
               RowBox[{
                SuperscriptBox["b", "2"], " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "-", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q", " ", "r"}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "4"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["b", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
               RowBox[{
                SuperscriptBox["a", "4"], " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["b", "4"], " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["b", "2"], "-", 
               SuperscriptBox["c", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["c", "2"]}], " ", "p"}], "-", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"p", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "p"}], "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "r"}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "4"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["b", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["c", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["b", "2"], " ", 
                SuperscriptBox["c", "2"], " ", "q", " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["b", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["c", "4"], " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "-", "r"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["a", "2"]}], "+", 
               SuperscriptBox["c", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["a", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "-", "q"}], ")"}], " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "q"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}]}], ")"}]}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", 
                 SuperscriptBox["b", "2"]}], " ", "p"}], "-", 
               RowBox[{
                SuperscriptBox["a", "2"], " ", "q"}]}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "4"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["a", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["c", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{"q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "2"}], " ", 
                SuperscriptBox["a", "2"], " ", 
                SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["a", "4"], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", "r"}], "+", 
               RowBox[{
                SuperscriptBox["c", "4"], " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "p"}], "+", "q"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["a", "2"], "-", 
               SuperscriptBox["b", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}]}], "}"}]}], ",", 
     RowBox[{"37", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", "r", " ", "SA"}]}], 
           ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}], "+", 
            RowBox[{"p", " ", "q", " ", "SB"}], "+", 
            RowBox[{"p", " ", "r", " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"p", " ", "q", " ", "SA"}], "+", 
            RowBox[{"q", " ", "r", " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{"p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"p", " ", "r", " ", "SA"}], "+", 
            RowBox[{"q", " ", "r", " ", "SB"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"38", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"2", " ", "p"}], "+", "q", "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", 
                SuperscriptBox["b", "2"]}], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "p"}], "-", "q", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "2"}], " ", "p"}], "+", "q", "+", "r"}], 
                ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", 
              RowBox[{"2", " ", "q"}], "-", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"p", "+", "r"}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{"q", "+", "r"}], ")"}]}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["a", "2"], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", 
                 RowBox[{"2", " ", "q"}], "-", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "+", "r"}], ")"}]}], "-", 
              RowBox[{
               SuperscriptBox["b", "2"], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", 
                 RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}]}], ",", 
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"p", "+", "q", "+", 
             RowBox[{"2", " ", "r"}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "q", "-", 
                RowBox[{"2", " ", "r"}]}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"p", "+", "r"}], ")"}], " ", 
              RowBox[{"(", 
               RowBox[{"q", "+", "r"}], ")"}]}], "-", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SuperscriptBox["a", "2"], " ", "q", " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "-", "q", "-", 
                   RowBox[{"2", " ", "r"}]}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "+", "r"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["b", "2"], " ", "p", " ", 
                 RowBox[{"(", 
                  RowBox[{"q", "+", "r"}], ")"}], " ", 
                 RowBox[{"(", 
                  RowBox[{"p", "-", "q", "+", 
                   RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
          ")"}]}]}], "}"}]}], ",", 
     RowBox[{"39", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             SuperscriptBox["p", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["p", "2"], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["b", "2"], "-", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
               RowBox[{"(", 
                RowBox[{"q", "-", "r"}], ")"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"p", " ", "r"}], "+", 
            RowBox[{"q", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", "p", " ", 
             SuperscriptBox["q", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
             RowBox[{"(", 
              RowBox[{
               SuperscriptBox["q", "2"], "+", 
               RowBox[{"p", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  SuperscriptBox["a", "2"]}], "+", 
                 SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", "p"}], "+", "r"}], ")"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               RowBox[{"2", " ", "p", " ", "r"}], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", 
            RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}], ",", 
        RowBox[{
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 SuperscriptBox["a", "2"], "-", 
                 SuperscriptBox["b", "2"]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"p", "-", "q"}], ")"}], " ", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", "q"}], "+", 
               RowBox[{"p", " ", "r"}], "+", 
               RowBox[{"q", " ", "r"}]}], ")"}]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", "q"}], "+", 
               SuperscriptBox["r", "2"]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{"4", " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q", "+", 
            RowBox[{"2", " ", "r"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}], " ", 
          SuperscriptBox["S", "2"]}]}]}], "}"}]}], ",", 
     RowBox[{"40", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["a", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "p", " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], "+", 
            SuperscriptBox["c", "2"]}], ")"}], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["c", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", 
               RowBox[{"3", " ", "q"}], "+", "r"}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p"}], "+", "q", "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"q", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "p"}], "+", 
                   RowBox[{"2", " ", "q"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "q"}], "+", 
                  RowBox[{"6", " ", 
                   SuperscriptBox["q", "2"]}]}], ")"}], " ", "r"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", "p"}], "+", 
                  RowBox[{"2", " ", "q"}]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "r", " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"q", "+", 
                  RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["p", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", "q"}], "+", 
                  RowBox[{"9", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", 
                   SuperscriptBox["q", "2"]}], "+", 
                  RowBox[{"15", " ", "q", " ", "r"}], "+", 
                  RowBox[{"12", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"6", " ", "p", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"5", " ", "q", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["a", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", 
               RowBox[{"2", " ", "q"}], "+", "r"}], ")"}]}], "-", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"2", " ", "q"}], "+", 
               RowBox[{"3", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "p", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "r"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "p"}], "+", "r"}], ")"}]}], "+", 
               RowBox[{
                SuperscriptBox["q", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"9", " ", "p"}], "+", 
                  RowBox[{"7", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"12", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "r"}], "+", 
                  RowBox[{"5", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"r", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"3", " ", "q"}], "+", 
                   RowBox[{"2", " ", "r"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["p", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", "q"}], "+", 
                  RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"p", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", 
                   SuperscriptBox["q", "2"]}], "+", 
                  RowBox[{"15", " ", "q", " ", "r"}], "+", 
                  RowBox[{"6", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["c", "4"]}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"6", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"5", " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "q"}], ")"}], " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], "+", 
            SuperscriptBox["b", "2"]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", "p"}], "+", "q", "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", 
               RowBox[{"3", " ", "q"}], "+", 
               RowBox[{"2", " ", "r"}]}], ")"}]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"p", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "q", " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", "q"}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"p", "+", 
                  RowBox[{"2", " ", "q"}]}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"5", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "q"}], "+", 
                  RowBox[{"12", " ", 
                   SuperscriptBox["q", "2"]}]}], ")"}], " ", "r"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"7", " ", "p"}], "+", 
                  RowBox[{"9", " ", "q"}]}], ")"}], " ", 
                SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             RowBox[{"(", 
              RowBox[{"q", "+", "r"}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"p", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"2", " ", "p"}], "+", 
                   RowBox[{"3", " ", "r"}]}], ")"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["q", "2"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"2", " ", "p"}], "+", 
                  RowBox[{"5", " ", "r"}]}], ")"}]}], "+", 
               RowBox[{"q", " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"6", " ", 
                   SuperscriptBox["p", "2"]}], "+", 
                  RowBox[{"15", " ", "p", " ", "r"}], "+", 
                  RowBox[{"7", " ", 
                   SuperscriptBox["r", "2"]}]}], ")"}]}]}], ")"}]}]}], 
           ")"}]}]}]}], "}"}]}], ",", 
     RowBox[{"41", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "4"]}], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["a", "2"]}], " ", "p", " ", "q"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["q", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["c", "4"]}], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}], ",", 
        RowBox[{
         SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", "p", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "p", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", "q", " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", "q", " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["r", "2"]}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["q", "2"], " ", "r"}], "-", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "3"], " ", "r"}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", "q", " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["c", "4"], " ", 
            SuperscriptBox["p", "2"], " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["b", "2"], " ", "p", " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "2"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "3"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"], " ", 
            SuperscriptBox["p", "2"], " ", "q", " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "+", 
           RowBox[{
            SuperscriptBox["a", "2"], " ", 
            SuperscriptBox["c", "2"], " ", "p", " ", 
            SuperscriptBox["q", "2"], " ", 
            SuperscriptBox["r", "3"]}], "-", 
           RowBox[{
            SuperscriptBox["a", "4"], " ", 
            SuperscriptBox["q", "3"], " ", 
            SuperscriptBox["r", "3"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"42", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "2"], " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q", " ", "r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "SB"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "2"], " ", "p", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "r", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["c", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["r", "2"], " ", "SC"}]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["c", "2"], " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["b", "2"], " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["a", "2"], " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p", " ", "q", " ", 
             SuperscriptBox["S", "2"]}], "+", 
            RowBox[{
             SuperscriptBox["b", "2"], " ", 
             SuperscriptBox["p", "2"], " ", "SA"}], "+", 
            RowBox[{
             SuperscriptBox["a", "2"], " ", 
             SuperscriptBox["q", "2"], " ", "SB"}]}], ")"}]}]}]}], "}"}]}], 
     ",", 
     RowBox[{"43", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p"}], "+", "q", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["p", "2"]}], "+", 
           RowBox[{"2", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", "p", " ", "r"}], "+", 
           RowBox[{"q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", 
           RowBox[{"2", " ", "q"}], "+", "r"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "p", " ", "q"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["q", "2"]}], "+", 
           RowBox[{"p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"p", "+", "q"}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{"p", "+", "q", "+", 
           RowBox[{"2", " ", "r"}]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"p", " ", "q"}], "+", 
           RowBox[{"2", " ", "p", " ", "r"}], "+", 
           RowBox[{"2", " ", "q", " ", "r"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["r", "2"]}]}], ")"}]}]}], "}"}]}], ",", 
     RowBox[{"44", "->", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "q"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "q"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "-", 
            RowBox[{"q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "q"}], "-", 
            RowBox[{"q", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", "p", " ", "q"}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"7", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             SuperscriptBox["p", "3"]}], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            SuperscriptBox["q", "3"], "-", 
            RowBox[{
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"3", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            SuperscriptBox["r", "3"]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"2", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", "p", " ", "q"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"p", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", "p", " ", "q"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}], "-", 
            SuperscriptBox["r", "2"]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "q"}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "q"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "3"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "3"]}], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"2", " ", "q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            SuperscriptBox["r", "3"]}], ")"}]}]}], ",", 
        RowBox[{
         RowBox[{
          SuperscriptBox["a", "6"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", "p"}], "+", 
            RowBox[{"3", " ", "q"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", "p"}], "+", 
            RowBox[{"2", " ", "q"}]}], ")"}], " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["c", "6"], " ", 
          SuperscriptBox["p", "2"], " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["q", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["p", "2"]}], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"4", " ", "p", " ", "r"}], "+", 
            RowBox[{"3", " ", "q", " ", "r"}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"], " ", 
          SuperscriptBox["p", "2"], " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"]}], "-", 
            SuperscriptBox["q", "2"], "+", 
            RowBox[{"3", " ", "p", " ", "r"}], "+", 
            RowBox[{"4", " ", "q", " ", "r"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["c", "4"], " ", "p", " ", 
          SuperscriptBox["q", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"p", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "p"}], " ", "q"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"2", " ", "p", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"], " ", 
          SuperscriptBox["p", "2"], " ", "q", " ", 
          RowBox[{"(", 
           RowBox[{"q", "+", "r"}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], " ", 
             SuperscriptBox["p", "2"]}], "-", 
            RowBox[{"p", " ", "q"}], "-", 
            RowBox[{"2", " ", "q", " ", "r"}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "4"], " ", "p", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"7", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"2", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "-", 
            RowBox[{"4", " ", 
             SuperscriptBox["q", "3"]}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"4", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "-", 
         RowBox[{
          SuperscriptBox["a", "4"], " ", 
          SuperscriptBox["b", "2"], " ", "q", " ", 
          SuperscriptBox["r", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "4"}], " ", 
             SuperscriptBox["p", "3"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "+", 
            RowBox[{"7", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            RowBox[{"9", " ", "p", " ", "q", " ", "r"}], "+", 
            RowBox[{"6", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "+", 
            RowBox[{"4", " ", "p", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"6", " ", "q", " ", 
             SuperscriptBox["r", "2"]}]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["a", "2"], " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"], " ", "p", " ", "q", " ", "r", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["p", "3"], "-", 
            RowBox[{"3", " ", 
             SuperscriptBox["p", "2"], " ", "q"}], "-", 
            RowBox[{"3", " ", "p", " ", 
             SuperscriptBox["q", "2"]}], "+", 
            SuperscriptBox["q", "3"], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["p", "2"], " ", "r"}], "-", 
            RowBox[{"4", " ", "p", " ", "q", " ", "r"}], "-", 
            RowBox[{"2", " ", 
             SuperscriptBox["q", "2"], " ", "r"}], "-", 
            RowBox[{"p", " ", 
             SuperscriptBox["r", "2"]}], "-", 
            RowBox[{"q", " ", 
             SuperscriptBox["r", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["r", "3"]}]}], ")"}]}]}]}], "}"}]}]}], "|>"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945841589546528*^9, 3.945841604944151*^9}, {
   3.9458416486015606`*^9, 3.945841701130226*^9}, 3.94584180266897*^9, {
   3.945841855521532*^9, 3.945841865133842*^9}, {3.9458419743855267`*^9, 
   3.94584197851943*^9}, {3.945842012120521*^9, 3.945842016064451*^9}, {
   3.945842114756489*^9, 3.945842119338508*^9}, {3.945842170028664*^9, 
   3.945842174123476*^9}, {3.945842254968681*^9, 3.9458422593104534`*^9}, {
   3.94584246069957*^9, 3.945842465998068*^9}, {3.945842501032144*^9, 
   3.9458425325383263`*^9}, {3.945842735167492*^9, 3.945842742091593*^9}, {
   3.945842846919035*^9, 3.945842850061655*^9}, {3.945842936494915*^9, 
   3.945842969633366*^9}, {3.945843125849571*^9, 3.94584313274209*^9}, {
   3.945843174894972*^9, 3.945843178277809*^9}, {3.9458432197775517`*^9, 
   3.9458432370243473`*^9}, {3.945843287330616*^9, 3.9458432907977543`*^9}, {
   3.945843326923149*^9, 3.9458433430906563`*^9}, {3.945843384493232*^9, 
   3.945843387811741*^9}, {3.945843423557177*^9, 3.945843427076299*^9}, {
   3.9458460856414566`*^9, 3.9458460903603935`*^9}, {3.9458461244501*^9, 
   3.945846127392929*^9}, {3.945846273464027*^9, 3.945846279270181*^9}, {
   3.945846311960058*^9, 3.945846315350111*^9}, {3.945846366817175*^9, 
   3.945846382831234*^9}, {3.945846756353731*^9, 3.9458467662170296`*^9}, {
   3.945846811099188*^9, 3.945846841686339*^9}, {3.945846884211832*^9, 
   3.945847260236458*^9}, {3.945847371762398*^9, 3.9458473779483223`*^9}, {
   3.945847468577452*^9, 3.945847473866535*^9}, {3.9458476375888367`*^9, 
   3.945847641254919*^9}, {3.945847770316178*^9, 3.9458477741893463`*^9}, {
   3.94584781182493*^9, 3.9458478153183575`*^9}, {3.94584788583465*^9, 
   3.945847888720951*^9}, {3.94584794845273*^9, 3.9458479545306664`*^9}, {
   3.945848036235821*^9, 3.945848039850874*^9}, {3.945848209145437*^9, 
   3.945848213365254*^9}, {3.945848428704586*^9, 3.945848437990104*^9}, {
   3.945848526693582*^9, 3.945848534626331*^9}, {3.945848666528978*^9, 
   3.94584868269029*^9}, {3.945848775077949*^9, 3.945848778998434*^9}, {
   3.945848877398905*^9, 3.945848886629158*^9}, {3.9458491238654*^9, 
   3.945849128054989*^9}, {3.945849197156975*^9, 3.9458492011715355`*^9}, {
   3.9458492397412167`*^9, 3.945849244243763*^9}, 3.945849479846901*^9, {
   3.945851715909244*^9, 3.945851732617178*^9}, 3.945853235726444*^9, {
   3.945853633264748*^9, 3.9458536354922667`*^9}, {3.946058981146543*^9, 
   3.946058983238126*^9}, {3.946113816440451*^9, 3.946113833217655*^9}, 
   3.946113923272053*^9, 3.9462998579964046`*^9},
 CellLabel->
  "In[160]:=",ExpressionUUID->"90297db1-2eea-6346-9338-a3e8dcfe0024"]
}, Closed]],

Cell[CellGroupData[{

Cell["QAP constructions", "Subsection",
 CellChangeTimes->{{3.946258018000845*^9, 3.9462580514460297`*^9}, {
  3.946439582465828*^9, 
  3.94643958360841*^9}},ExpressionUUID->"79ef6085-3de7-3c49-8561-\
f943fbd2d431"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP1", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258220966779*^9, 3.946258253166219*^9}},
 CellLabel->
  "In[161]:=",ExpressionUUID->"e725b315-4161-274c-8798-a4e0c807d6a8"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP2", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"PonceletPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258127112749*^9, 3.946258205014044*^9}},
 CellLabel->
  "In[162]:=",ExpressionUUID->"60fea3de-a36e-734d-b67f-75eab8f36838"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP3", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258267006763*^9, 3.946258272798765*^9}},
 CellLabel->
  "In[163]:=",ExpressionUUID->"422bd8e2-a85e-d748-b542-6c9b62c11efd"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP4", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsogonal", "[", 
        RowBox[{"P", ",", 
         RowBox[{"{", 
          RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsogonal", "[", 
        RowBox[{"Q", ",", 
         RowBox[{"{", 
          RowBox[{"P", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946258285271057*^9, 3.946258529254532*^9}, {
  3.946258821686931*^9, 3.946258862614427*^9}},
 CellLabel->
  "In[164]:=",ExpressionUUID->"d021f1ab-c58d-b74b-8aa5-a62365464cc5"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP5", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsotomico", "[", 
        RowBox[{"P", ",", 
         RowBox[{"{", 
          RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", "P"}], 
      "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"ConjugadoIsotomico", "[", 
        RowBox[{"Q", ",", 
         RowBox[{"{", 
          RowBox[{"P", ",", "R", ",", "S"}], "}"}]}], "]"}], ",", "Q"}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946552139912605*^9, 3.946552177047758*^9}},
 CellLabel->
  "In[165]:=",ExpressionUUID->"023d4850-e194-b941-a762-4c9a532e11d1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP6", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Medio", "[", 
    RowBox[{
     RowBox[{"QAP2", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}], ",", 
     RowBox[{"QAP4", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946554002925066*^9, 3.946554042045203*^9}},
 CellLabel->
  "In[166]:=",ExpressionUUID->"62ef2468-c328-714d-8bf7-299b142a086d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP7", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Q1", ",", "Q2", ",", "Q3", ",", "Q4", ",", "R1", ",", "R2"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Q1", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q2", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q3", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Q4", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"R1", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q2", ",", "Q3", ",", "Q4"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"R2", "=", 
       RowBox[{"CentroNuevePuntos", "[", 
        RowBox[{"{", 
         RowBox[{"Q1", ",", "Q3", ",", "Q4"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R1"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R2"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946258285271057*^9, 3.946258529254532*^9}, {
  3.946258821686931*^9, 3.946258862614427*^9}, {3.946290848591799*^9, 
  3.946291021534954*^9}, {3.946291111031261*^9, 3.946291120455242*^9}, {
  3.946696200711548*^9, 3.946696200806263*^9}},
 CellLabel->
  "In[167]:=",ExpressionUUID->"d734f707-6812-364b-b359-ac3a6bb66e72"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"MiquelPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"U", ",", "V", ",", "O1", ",", "O2"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"U", "=", 
       RowBox[{"Punto", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "Q"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"V", "=", 
       RowBox[{"Punto", "[", 
        RowBox[{
         RowBox[{"Recta", "[", 
          RowBox[{"P", ",", "S"}], "]"}], ",", 
         RowBox[{"Recta", "[", 
          RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"O1", "=", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "S", ",", "U"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"O2", "=", 
       RowBox[{"Circuncentro", "[", 
        RowBox[{"{", 
         RowBox[{"R", ",", "S", ",", "V"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SimetriaAxial", "[", 
       RowBox[{"S", ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"O1", ",", "O2"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]",
     "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946294457093628*^9, 3.946294688202664*^9}, {
   3.9462961458488*^9, 3.9462961471441994`*^9}, 3.9462963028076897`*^9, {
   3.9462973681984005`*^9, 3.946297370950136*^9}},
 CellLabel->
  "In[168]:=",ExpressionUUID->"34f7e383-98aa-bc47-9867-166186424dd4"],

Cell[BoxData[
 RowBox[{
  RowBox[{"MiquelCircle", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"U", ",", "V", ",", "W", ",", "O1", ",", "O2", ",", "O3"}], 
     "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"U", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"V", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O1", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "S", ",", "U"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O2", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"R", ",", "S", ",", "V"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"O3", "=", 
      RowBox[{"Circuncentro", "[", 
       RowBox[{"{", 
        RowBox[{"Q", ",", "R", ",", "U"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CircunferenciaTresPuntos", "[", 
      RowBox[{"{", 
       RowBox[{"O1", ",", "O2", ",", "O3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946295931650831*^9, 3.9462959921519623`*^9}, {
  3.9462960978401566`*^9, 3.946296126960247*^9}, {3.946296309416164*^9, 
  3.946296387663599*^9}, {3.946296507206955*^9, 3.946296515015978*^9}, {
  3.9462965951590157`*^9, 3.9462966339272327`*^9}},
 CellLabel->
  "In[169]:=",ExpressionUUID->"4370c731-693f-a941-82c8-1f6a14f724b2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP8", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"SimetriaCentral", "[", 
    RowBox[{
     RowBox[{"QAP4", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}], ",", 
     RowBox[{"QAP2", "[", 
      RowBox[{"{", 
       RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.946554262541748*^9, 3.946554276084837*^9}},
 CellLabel->
  "In[170]:=",ExpressionUUID->"6e2024d9-4541-ea4e-a308-49a8bb9b87a5"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP9", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c1", ",", "c2", ",", "c3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"c1", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"c2", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "Q", ",", "S", ",", "R"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"c3", "=", 
      RowBox[{"MiquelCircle", "[", 
       RowBox[{"{", 
        RowBox[{"P", ",", "R", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"CentroRadical", "[", 
      RowBox[{"c1", ",", "c2", ",", "c3"}], "]"}]}]}], "\[IndentingNewLine]", 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9462975678957386`*^9, 3.94629768995805*^9}},
 CellLabel->
  "In[171]:=",ExpressionUUID->"384fc915-4ebd-5342-9174-a166a5e7f52d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP10", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Baricentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946554372389721*^9, 3.94655438207695*^9}},
 CellLabel->
  "In[172]:=",ExpressionUUID->"e878baba-ea71-dd4f-b972-2e4c3753c774"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP11", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Circuncentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.946554416053346*^9, 3.946554423653038*^9}},
 CellLabel->
  "In[173]:=",ExpressionUUID->"4200ee2b-abeb-b246-85fa-68f1ce5d836b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"QAP12", "[", 
   RowBox[{"{", 
    RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"S1", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "S"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S2", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "R"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"S3", "=", 
      RowBox[{"Punto", "[", 
       RowBox[{
        RowBox[{"Recta", "[", 
         RowBox[{"P", ",", "Q"}], "]"}], ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"R", ",", "S"}], "]"}]}], "]"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Ortocentro", "[", 
      RowBox[{"{", 
       RowBox[{"S1", ",", "S2", ",", "S3"}], "}"}], "]"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellLabel->
  "In[174]:=",ExpressionUUID->"8131db8a-5012-e741-93f3-ec6da52923f1"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"QAP34", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1", ",", "P2", ",", "P3", ",", "P4"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"P1", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"Q", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P2", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "R", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P3", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "S"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"P4", "=", 
       RowBox[{"Baricentro", "[", 
        RowBox[{"{", 
         RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"QAP2", "[", 
       RowBox[{"{", 
        RowBox[{"P1", ",", "P2", ",", "P3", ",", "P4"}], "}"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.946362022452154*^9, 3.9463621697479362`*^9}},
 CellLabel->
  "In[175]:=",ExpressionUUID->"3e5eb206-464c-7e4f-b628-98c50c5a4629"]
}, Closed]],

Cell[CellGroupData[{

Cell["Auxiliary functions", "Subsection",
 CellChangeTimes->{
  3.818667972143658*^9, {3.8186680382464933`*^9, 3.818668041714528*^9}, {
   3.818668136826049*^9, 3.818668143553762*^9}, {3.818685183717651*^9, 
   3.818685185711126*^9}},ExpressionUUID->"d004e03f-8f12-9a43-865f-\
339812029417"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "powers", " ", "of", " ", 
     "S"}], "=", 
    RowBox[{"2", "[", "ABC", "]"}]}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        SuperscriptBox["b", "4"], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "4"]}], ")"}], "/", "4"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustS", "=", 
     RowBox[{"{", 
      RowBox[{
       SuperscriptBox["S", "n_"], "\[Rule]", 
       RowBox[{
        SuperscriptBox["S2", 
         RowBox[{"Quotient", "[", 
          RowBox[{"n", ",", "2"}], "]"}]], 
        SuperscriptBox["S", 
         RowBox[{"Mod", "[", 
          RowBox[{"n", ",", "2"}], "]"}]]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Rule", " ", "for", " ", "replacing", " ", "Conway", " ", "symbols"}], 
    " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sustC", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"SA", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"a", "^", "2"}]}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SB", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "-", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SC", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "-", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}], ",", " ", 
       RowBox[{"SW", "->", 
        RowBox[{
         RowBox[{"1", "/", "2"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"a", "^", "2"}], "+", 
           RowBox[{"b", "^", "2"}], "+", 
           RowBox[{"c", "^", "2"}]}], ")"}]}]}]}], "}"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"EqualPointsQ", "[", 
      RowBox[{"ptP_", ",", "ptQ_", ",", 
       RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
     RowBox[{
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"Cross", "[", 
           RowBox[{"ptP", ",", "ptQ"}], "]"}], "/.", "sustS"}], "/.", 
         "sustC"}], ",", "cond"}], "]"}], "===", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.947132996916015*^9, 3.9471330125156*^9}, {
  3.947133479684403*^9, 3.947133480044634*^9}},
 CellLabel->
  "In[176]:=",ExpressionUUID->"059a14ad-548f-1d43-b181-7239fd1e5301"]
}, Closed]],

Cell[CellGroupData[{

Cell["Quadrilateral routines", "Subsection",
 CellChangeTimes->{{3.945509919017998*^9, 
  3.945509932600797*^9}},ExpressionUUID->"2a49be25-3c4e-430e-86c6-\
869880736f30"],

Cell[CellGroupData[{

Cell["Vertex centroid", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.947132319963703*^9, 
  3.947132328106987*^9}},ExpressionUUID->"a576f9af-1f5b-4213-b4d3-\
e7b66981337e"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzs3Qd8FGX+P3D+v7v7nb+zAPZTT7EgoJyn56moZ0fQKBq6dIggATVSgmBo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    "], {{0, 389.2075471698113}, {491.0943396226415, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{491.0943396226415, 389.2075471698113},
  PlotRange->{{0, 491.0943396226415}, {0, 389.2075471698113}}]], "Text",
 CellChangeTimes->{
  3.945509787103263*^9},ExpressionUUID->"f7950398-57cb-4ee6-bf14-\
597b39eb91df"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentroidQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"Medio", "[", 
        RowBox[{"P", ",", "Q"}], "]"}], ",", 
       RowBox[{"Medio", "[", 
        RowBox[{"R", ",", "S"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Recta", "[", 
      RowBox[{
       RowBox[{"Medio", "[", 
        RowBox[{"P", ",", "S"}], "]"}], ",", 
       RowBox[{"Medio", "[", 
        RowBox[{"Q", ",", "R"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
  3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
  3.9455136200666037`*^9}, {3.946439211017157*^9, 3.946439211737526*^9}},
 CellLabel->
  "In[180]:=",ExpressionUUID->"cf738f77-0d96-4e62-81a0-f2a504594dc8"]
}, Closed]],

Cell[CellGroupData[{

Cell["Poncelet point", "Subsubsection",
 CellChangeTimes->{{3.945509682961616*^9, 3.945509705247427*^9}, {
   3.945516718286007*^9, 3.945516720220911*^9}, 
   3.947132291355841*^9},ExpressionUUID->"f7957972-a4e9-446f-bafd-\
6774f0dd3699"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "PuntoDePoncelet", " ", "is", " ", "implemented", " ", "in", " ", "the", 
    " ", "baricentricas", " ", "package"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"PonceletPoint", "[", 
     RowBox[{"{", 
      RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
    RowBox[{"PuntoDePoncelet", "[", 
     RowBox[{"P", ",", 
      RowBox[{"{", 
       RowBox[{"Q", ",", "R", ",", "S"}], "}"}]}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.945506298668439*^9, 3.9455064957646704`*^9}, {
  3.945508100242526*^9, 3.945508119954049*^9}, {3.9455093671686244`*^9, 
  3.945509538952415*^9}, {3.9455167413982186`*^9, 3.945516826125304*^9}},
 CellLabel->
  "In[181]:=",ExpressionUUID->"44de57fd-6e7d-4d98-94a0-c7b93947eadd"]
}, Closed]],

Cell[CellGroupData[{

Cell["Steiner point", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
  3.947132277507908*^9, 
  3.947132283924074*^9}},ExpressionUUID->"ae32c2db-9871-344f-aabd-\
a2543db56100"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SteinerPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "X", ",", "Y", ",", "Z", ",", "T", ",", "U", ",", "V", ",", "W"}], 
      "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"X", ",", "Y", ",", "Z", ",", "U", ",", "T"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Apply", "[", 
          RowBox[{"Medio", ",", "#"}], "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"P", ",", "S"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "Q"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"R", ",", "Q"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"P", ",", "R"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"S", ",", "Q"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"V", ",", "W"}], "}"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"Circuncentro", "[", "#", "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"X", ",", "Y", ",", "U"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Y", ",", "Z", ",", "T"}], "}"}]}], "}"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"SimetriaAxial", "[", 
       RowBox[{"Y", ",", 
        RowBox[{"Recta", "[", 
         RowBox[{"V", ",", "W"}], "]"}]}], "]"}]}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945506298668439*^9, 3.9455064957646704`*^9}, {
  3.945508100242526*^9, 3.945508119954049*^9}, {3.9455093671686244`*^9, 
  3.945509538952415*^9}, {3.945518206235336*^9, 3.945518260181164*^9}, {
  3.945518437370175*^9, 3.9455184493471375`*^9}, {3.947132243612131*^9, 
  3.947132244379742*^9}},
 CellLabel->
  "In[182]:=",ExpressionUUID->"db0fcba9-9144-4df7-981b-db22bb466a6e"]
}, Closed]],

Cell[CellGroupData[{

Cell["Diagonal point", "Subsubsection",
 CellChangeTimes->{{3.945509731593883*^9, 3.9455097416152782`*^9}, {
   3.945521331783347*^9, 3.9455213360947638`*^9}, 
   3.947132343027188*^9},ExpressionUUID->"29f12ada-9fd0-4747-b323-\
2cf96d6fb52e"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DiagonalPoint", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{"Punto", "[", 
    RowBox[{
     RowBox[{"Recta", "[", 
      RowBox[{"P", ",", "R"}], "]"}], ",", 
     RowBox[{"Recta", "[", 
      RowBox[{"Q", ",", "S"}], "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.94550498095276*^9, 3.9455049885588703`*^9}, {
  3.945505050783066*^9, 3.945505141118817*^9}, {3.945513617473904*^9, 
  3.9455136200666037`*^9}, {3.945521346455207*^9, 3.9455213813107405`*^9}},
 CellLabel->
  "In[183]:=",ExpressionUUID->"158fb412-c771-43ab-b43b-a357380f4a11"]
}, Closed]],

Cell[CellGroupData[{

Cell["Central quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.9464416787367783`*^9, 3.946441687230852*^9}, 
   3.947147898383025*^9},ExpressionUUID->"5a543829-5641-9144-8dd0-\
57eb7cf1938d"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CentralQuadrilateral", "[", "n_", "]"}], ":=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptB", ",", "ptC", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptC", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptD"}], "}"}]}], "]"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Simplificar", "[", 
      RowBox[{"CentroETCTriangulo", "[", 
       RowBox[{
        RowBox[{"ETC", "[", 
         RowBox[{"[", 
          RowBox[{"n", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"ptA", ",", "ptB", ",", "ptC"}], "}"}]}], "]"}], "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellLabel->
  "In[184]:=",ExpressionUUID->"35cb8ff3-829e-654a-a95d-e2c972de6be9"]
}, Closed]],

Cell[CellGroupData[{

Cell["Area of a quadrilateral", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 
  3.945509840152308*^9}},ExpressionUUID->"e039afe9-d89d-4ec4-94b9-\
ddb3f9f259e0"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"AreaQuad", "[", 
    RowBox[{"{", 
     RowBox[{"P_", ",", "Q_", ",", "R_", ",", "S_"}], "}"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"AreaTriangulo", "[", 
     RowBox[{"{", 
      RowBox[{"P", ",", "Q", ",", "R"}], "}"}], "]"}], "+", 
    RowBox[{"AreaTriangulo", "[", 
     RowBox[{"{", 
      RowBox[{"R", ",", "S", ",", "P"}], "}"}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.945518557002711*^9, 3.945518607763227*^9}},
 CellLabel->
  "In[185]:=",ExpressionUUID->"2db3c5dc-e4da-4371-937a-22cb108c81e1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Perspective quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945619500071995*^9, 3.9456195111611595`*^9}, {
   3.94561961722077*^9, 3.945619628845907*^9}, {3.945620201468649*^9, 
   3.945620207996176*^9}, {3.946093948975952*^9, 3.946093951552325*^9}, 
   3.94619393871496*^9, 
   3.947147899655007*^9},ExpressionUUID->"bd16b166-d506-5544-b5d0-\
7aa6edfca35b"],

Cell[BoxData[
 RowBox[{
  RowBox[{"PerspectiveQ", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "P2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "Q2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"R1", ",", "R2"}], "]"}]}], "}"}], "]"}], "==", "0"}], "&&", 
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "P2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "Q2"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"S1", ",", "S2"}], "]"}]}], "}"}], "]"}], "==", 
    "0"}]}]}]], "Input",
 CellChangeTimes->{{3.945619541933253*^9, 3.945619598797678*^9}, {
  3.945620227236483*^9, 3.945620398996369*^9}, {3.946093956887635*^9, 
  3.9460940140877304`*^9}, {3.9460946192084503`*^9, 3.9460946637685833`*^9}},
 CellLabel->
  "In[186]:=",ExpressionUUID->"6cd12b17-ccf6-1f40-8216-e746f72a898c"]
}, Closed]],

Cell[CellGroupData[{

Cell["Similar and homothetic quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 3.945509840152308*^9}, {
  3.945518917754542*^9, 3.945518929298341*^9}, {3.94551954978488*^9, 
  3.945519554745524*^9}, {3.9471326902197247`*^9, 3.9471326941873684`*^9}, {
  3.947132774954735*^9, 
  3.947132785771118*^9}},ExpressionUUID->"d546f79d-5ed9-4f99-846e-\
3ac1a3756b86"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SimilarQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"SonSemejantes", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P1", ",", "Q1", ",", "R1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"P2", ",", "Q2", ",", "R2"}], "}"}]}], "]"}], "&&", 
    RowBox[{"SonSemejantes", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Q1", ",", "R1", ",", "S1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Q2", ",", "R2", ",", "S2"}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945518557002711*^9, 3.945518607763227*^9}, {
  3.9455189375627*^9, 3.945519039097607*^9}, {3.945519562008997*^9, 
  3.945519564865857*^9}},
 CellLabel->
  "In[187]:=",ExpressionUUID->"5668c7c2-b2f3-48b4-bb4e-3f493e46ab9c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"HomotheticQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{"SonHomoteticos", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"P1", ",", "Q1", ",", "R1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"P2", ",", "Q2", ",", "R2"}], "}"}]}], "]"}], "&&", 
    RowBox[{"SonHomoteticos", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Q1", ",", "R1", ",", "S1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Q2", ",", "R2", ",", "S2"}], "}"}]}], "]"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.9455195703380117`*^9, 3.945519605171223*^9}},
 CellLabel->
  "In[188]:=",ExpressionUUID->"d07dfa48-d9b6-433c-9d4d-8f2532f1bec3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Congruent quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.945619500071995*^9, 3.9456195111611595`*^9}, {
   3.94561961722077*^9, 3.945619628845907*^9}, {3.945620201468649*^9, 
   3.945620207996176*^9}, 3.946437820730978*^9, 
   3.9471479009831057`*^9},ExpressionUUID->"8f461d45-0647-c84b-9fe0-\
f72d3601c63f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"CongruentQuadQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"And", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P1", ",", "Q1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P2", ",", "Q2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"Q1", ",", "R1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"Q2", ",", "R2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"R1", ",", "S1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"R2", ",", "S2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"S1", ",", "P1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"S2", ",", "P2"}], "]"}]}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P1", ",", "R1"}], "]"}], "==", 
      RowBox[{"CuadradoDistancia", "[", 
       RowBox[{"P2", ",", "R2"}], "]"}]}]}], "\[IndentingNewLine]", "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.945619541933253*^9, 3.945619598797678*^9}, {
  3.945620227236483*^9, 3.945620398996369*^9}, {3.946287549140295*^9, 
  3.946287549827748*^9}},
 CellLabel->
  "In[189]:=",ExpressionUUID->"5485ed32-34f6-e64e-bd2a-b4e163c2b97f"]
}, Closed]],

Cell[CellGroupData[{

Cell["Orthogonal quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.946437760717503*^9, 3.9464377702703495`*^9}, 
   3.947147903551467*^9},ExpressionUUID->"54169a90-c35c-7a4a-a37f-\
78c9753e8eeb"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"OrthogonalQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P1_", ",", "Q1_", ",", "R1_", ",", "S1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"P2_", ",", "Q2_", ",", "R2_", ",", "S2_"}], "}"}]}], "]"}], ":=", 
   RowBox[{"And", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"P1", ",", "Q1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"P2", ",", "Q2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"Q1", ",", "R1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"Q2", ",", "R2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"R1", ",", "S1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"R2", ",", "S2"}], "]"}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"SonPerpendiculares", "[", 
      RowBox[{
       RowBox[{"Recta", "[", 
        RowBox[{"S1", ",", "P1"}], "]"}], ",", 
       RowBox[{"Recta", "[", 
        RowBox[{"S2", ",", "P2"}], "]"}]}], "]"}]}], "\[IndentingNewLine]", 
    "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9455195703380117`*^9, 3.945519605171223*^9}, {
  3.9460039858449364`*^9, 3.946003994260566*^9}, {3.946004044908913*^9, 
  3.946004131276815*^9}, {3.946004174101141*^9, 3.946004205589377*^9}},
 CellLabel->
  "In[190]:=",ExpressionUUID->"c1bc4c8d-1ecd-654a-b9e2-f902b4037dfa"]
}, Closed]],

Cell[CellGroupData[{

Cell["Conconic quadrilaterals", "Subsubsection",
 CellChangeTimes->{{3.946188760871956*^9, 3.946188779525741*^9}, {
  3.9464378271237335`*^9, 
  3.946437830963283*^9}},ExpressionUUID->"e126572d-bdab-a047-b925-\
c2661290f09e"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "returns", " ", "TRUE", " ", "if", " ", "ABCD", " ", "and", " ", "EFGH", 
    " ", "are", " ", "conconic"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"conconicQuadQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ptA_", ",", "ptB_", ",", "ptC_", ",", "ptD_"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ptE_", ",", "ptF_", ",", "ptG_", ",", "ptH_"}], "}"}]}], 
     "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "conic", "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"conic", "=", 
        RowBox[{"ConicaCincoPuntos", "[", 
         RowBox[{"{", 
          RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD", ",", "ptE"}], 
          "}"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"Map", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Sustituirxyz", "[", 
            RowBox[{"conic", ",", "#"}], "]"}], "&"}], ",", 
          RowBox[{"{", 
           RowBox[{"ptF", ",", "ptG", ",", "ptH"}], "}"}]}], "]"}], "==", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}]}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.946440275192674*^9, 3.946440364775547*^9}, {
  3.946557553720074*^9, 3.94655756021654*^9}},
 CellLabel->
  "In[191]:=",ExpressionUUID->"3eac6f83-9820-5d4f-9acd-4f2df1b13510"]
}, Closed]],

Cell[CellGroupData[{

Cell["Find QA center", "Subsubsection",
 CellChangeTimes->{{3.945509831673606*^9, 3.945509840152308*^9}, {
  3.945518917754542*^9, 3.945518929298341*^9}, {3.94551954978488*^9, 
  3.945519554745524*^9}, {3.946186993811855*^9, 
  3.946187000755444*^9}},ExpressionUUID->"1d12da59-37f1-9842-ad9c-\
eb916041816f"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", "findQACenter", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"findQACenter", "[", 
    RowBox[{"ptP_", ",", 
     RowBox[{"cond_", ":", "True"}]}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"found", "=", "0"}], ",", "sustCS", ",", 
       RowBox[{"nc", "=", 
        RowBox[{"Length", "[", "QAP", "]"}]}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"sustCS", "=", 
       RowBox[{"Join", "[", 
        RowBox[{"sustS", ",", "sustC"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Monitor", "[", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"i", "=", "1"}], ",", 
          RowBox[{"i", "<=", "nc"}], ",", 
          RowBox[{"i", "++"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"Simplify", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"Cross", "[", 
                   RowBox[{"ptP", ",", 
                    RowBox[{"QAP", "[", "i", "]"}]}], "]"}], "//.", 
                  "sustCS"}], ",", "cond"}], "]"}], ")"}], "==", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], ",", 
             RowBox[{
              RowBox[{"found", "=", "i"}], ";", 
              RowBox[{"Break", "[", "]"}]}]}], "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ",", "\[IndentingNewLine]", 
        RowBox[{"Row", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<Identifying the center... \>\"", ",", 
           RowBox[{"ProgressIndicator", "[", 
            RowBox[{"i", ",", 
             RowBox[{"{", 
              RowBox[{"1", ",", "nc"}], "}"}]}], "]"}], ",", "\"\< \>\"", ",",
            "i", ",", "\"\</\>\"", ",", "nc"}], "}"}], "]"}]}], 
       "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"found", "==", "0"}], ",", "\"\<unknown\>\"", ",", 
        RowBox[{"\"\<QA-P\>\"", "<>", 
         RowBox[{"ToString", "[", "found", "]"}]}]}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.946187173054329*^9, 3.946187213931603*^9}, {
   3.946187246486248*^9, 3.9461872843092823`*^9}, 3.946187365054121*^9, {
   3.946187480278492*^9, 3.9461874874540024`*^9}, 3.9461880462086487`*^9, {
   3.9461881054797783`*^9, 3.9461881291423397`*^9}, {3.946188268454359*^9, 
   3.9461883008316956`*^9}, {3.94618835627853*^9, 3.946188455318756*^9}, 
   3.946257761266403*^9, {3.946258916015583*^9, 3.94625896478343*^9}, {
   3.946259615877109*^9, 3.946259655534961*^9}, {3.947132891348004*^9, 
   3.947132924188181*^9}, {3.9471329718839912`*^9, 3.9471329845888424`*^9}, {
   3.947133025988367*^9, 3.94713303106756*^9}, {3.9471334511324463`*^9, 
   3.94713348841169*^9}},
 CellLabel->
  "In[192]:=",ExpressionUUID->"806c98e7-c027-de46-8fc2-cc2eda959f64"]
}, Closed]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Properties ", "Section",
 CellChangeTimes->{{3.9464385601246834`*^9, 3.9464385707657948`*^9}, {
  3.9464417172462025`*^9, 
  3.946441726397751*^9}},ExpressionUUID->"2609bf4c-7f5c-314e-a744-\
f86d4be283dd"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvV1sU2fa9+u9t7a0D3ywc8hBJLYiSzlAqlAU6QWhUXIQVGQpQUVRBI0s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    "], {{0, 177.2830188679245}, {671.7735849056603, 0}}, {0, 255},
    ColorFunction->RGBColor,
    ImageResolution->{106., 106.},
    RasterInterpolation->"High"],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{671.7735849056603, 177.2830188679245},
  PlotRange->{{0, 671.7735849056603}, {0, 177.2830188679245}}]], "Text",
 CellChangeTimes->{
  3.947586611392414*^9},ExpressionUUID->"6edcdd0e-574a-514a-a312-\
cbd371c30c4a"],

Cell[CellGroupData[{

Cell["X (35) ", "Subsection",
 CellChangeTimes->{{3.94647886735042*^9, 3.946478870724262*^9}, {
   3.946484241605079*^9, 3.946484242732435*^9}, 3.946545890008735*^9, 
   3.9474957904022446`*^9},ExpressionUUID->"c173dcb1-febd-9a4a-b5af-\
dfde8ba19c65"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "35", "]"}]}]], "Input",
 CellChangeTimes->{3.947495818459534*^9},
 CellLabel->
  "In[194]:=",ExpressionUUID->"4a5eadcd-c916-b942-b1b2-20d539b7d941"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"b", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["a", "2"]}], " ", "b"}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "-", "c"}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", "+", "c"}], ")"}], "2"]}]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", "c"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"b", "-", "c"}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", "+", "c"}], ")"}], "2"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           SuperscriptBox["b", "3"], "-", 
           RowBox[{"b", " ", 
            SuperscriptBox["c", "2"]}]}], "]"}]}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
           SuperscriptBox["c", "3"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "-", 
             SuperscriptBox["b", "2"], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}], ")"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
           SuperscriptBox["c", "3"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"b", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{"b", "-", "c"}], ")"}], " ", "c", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"b", "+", "c"}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["a", "2"], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"b", "-", "c"}], ")"}], " ", "c"}]}], ")"}]}], "+", 
          RowBox[{"a", " ", 
           SuperscriptBox["b", "2"], " ", 
           RowBox[{"Abs", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", 
               SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
             SuperscriptBox["c", "3"]}], "]"}]}]}], ")"}]}], ")"}]}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           SuperscriptBox["b", "3"], "-", 
           RowBox[{"b", " ", 
            SuperscriptBox["c", "2"]}]}], "]"}]}], "-", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
           SuperscriptBox["c", "3"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "b"}], " ", 
         RowBox[{"(", 
          RowBox[{"b", "-", "c"}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", "+", "c"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           RowBox[{"b", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "b"}], "+", "c"}], ")"}]}]}], ")"}]}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           SuperscriptBox["b", "3"], "-", 
           RowBox[{"b", " ", 
            SuperscriptBox["c", "2"]}]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "b"}], "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "+", 
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           SuperscriptBox["b", "3"], "-", 
           RowBox[{"b", " ", 
            SuperscriptBox["c", "2"]}]}], "]"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"b", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"a", " ", "b"}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.947495819277801*^9, {3.9475866209142723`*^9, 3.9475866469025993`*^9}},
 CellLabel->
  "Out[194]=",ExpressionUUID->"74d2b946-6d7c-be44-80a1-0ae151991ff8"]
}, Open  ]],

Cell["persp[ABCD, GHEF]", "Subsubsection",
 CellChangeTimes->{{3.946480913979744*^9, 3.946480925928507*^9}, {
  3.9475866242920475`*^9, 
  3.9475866266442795`*^9}},ExpressionUUID->"84514861-48cf-354f-a1d8-\
2fa86e35ac09"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"PerspectiveQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}]}], "]"}], 
   ",", "bitrap"}], "]"}]], "Input",
 CellChangeTimes->{{3.946484123988524*^9, 3.9464841249812183`*^9}, {
  3.94654582510405*^9, 3.946545839792419*^9}, {3.947495816389759*^9, 
  3.947495821195334*^9}},
 CellLabel->
  "In[195]:=",ExpressionUUID->"94388c6d-da73-be45-bb48-9f9ffc9dee06"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.946484125986685*^9, {3.946545796915268*^9, 3.9465458004312477`*^9}, 
   3.94654584063319*^9, 3.946552345552082*^9, 3.94655239154117*^9, {
   3.947495822097996*^9, 3.947495833645338*^9}, {3.947586628902302*^9, 
   3.947586648427807*^9}},
 CellLabel->
  "Out[195]=",ExpressionUUID->"929ff6ae-3e71-244c-b4ad-da783ef8c668"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (49)", "Subsection",
 CellChangeTimes->{{3.946478898766161*^9, 3.946478904220325*^9}, {
  3.9474965190573616`*^9, 
  3.947496519665365*^9}},ExpressionUUID->"d03feb85-5ec7-6843-823f-\
d6dddf7c9b44"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "49", "]"}]}]], "Input",
 CellChangeTimes->{3.947496586105816*^9},
 CellLabel->
  "In[196]:=",ExpressionUUID->"b5eedecd-d41c-4544-bfc5-f26ed8ef2138"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["c", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], "+", 
          SuperscriptBox["c", "2"]}], ")"}], "3"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "8"], "-", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "4"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "4"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"6", " ", 
          SuperscriptBox["b", "6"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", 
          SuperscriptBox["b", "8"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         SuperscriptBox["c", "8"]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      SuperscriptBox["b", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       SuperscriptBox["b", "4"]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "6"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         SuperscriptBox["c", "6"]}], ")"}]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "8"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         SuperscriptBox["c", "8"]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       SuperscriptBox["a", "8"], " ", 
       SuperscriptBox["c", "4"]}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "6"], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "6"], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "8"], "-", 
         RowBox[{
          SuperscriptBox["b", "6"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "6"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "8"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      SuperscriptBox["c", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.947496586782467*^9, 3.947586673541134*^9},
 CellLabel->
  "Out[196]=",ExpressionUUID->"1fc79ffb-7c3c-724b-a006-410924e36a66"]
}, Open  ]],

Cell["persp[ABCD, HGFE]", "Subsubsection",
 CellChangeTimes->{{3.946480958971756*^9, 3.9464809648964844`*^9}, {
  3.947586676643942*^9, 
  3.947586682308523*^9}},ExpressionUUID->"44c4fbe4-3b25-2b44-b3f9-\
05b92e35c416"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerspectiveQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"ptH", ",", "ptG", ",", "ptF", ",", "ptE"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.946484375956259*^9, 3.946484388812689*^9}, {
  3.946484743732359*^9, 3.946484745051697*^9}, {3.946484944236145*^9, 
  3.946484944315735*^9}, {3.9474965839636345`*^9, 3.947496591649502*^9}},
 CellLabel->
  "In[197]:=",ExpressionUUID->"d94e020f-2e70-2e4d-888b-7ce993a9645c"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946484389862408*^9, 3.9464847461500416`*^9, 
  3.946484945088333*^9, 3.94654603179298*^9, 3.947496600502594*^9, 
  3.9475866851982193`*^9},
 CellLabel->
  "Out[197]=",ExpressionUUID->"af38611f-7522-424f-8894-2d5f28c93789"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (55) ", "Subsection",
 CellChangeTimes->{{3.94647886735042*^9, 3.946478870724262*^9}, {
   3.946484241605079*^9, 3.946484242732435*^9}, 3.946545890008735*^9, {
   3.9474957936272297`*^9, 
   3.947495796306387*^9}},ExpressionUUID->"ea27e41e-d504-114f-a97f-\
3cc630e1f51a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "55", "]"}]}]], "Input",
 CellChangeTimes->{3.9474959404502716`*^9},
 CellLabel->
  "In[198]:=",ExpressionUUID->"bc34a32f-184f-cf4f-98f0-e85293ab587a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}]}], ",", 
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "a"}], " ", "b"}], "+", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"b", " ", "c"}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "+", "c"}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "-", "c"}], ")"}]}], "-", 
        RowBox[{"Abs", "[", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], "]"}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "-", "c"}], ")"}], " ", "c", " ", 
        RowBox[{"(", 
         RowBox[{"b", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"]}], "-", 
             RowBox[{"b", " ", "c"}], "-", 
             SuperscriptBox["c", "2"]}], ")"}]}], "+", 
          RowBox[{"c", " ", 
           RowBox[{"Abs", "[", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], "]"}]}]}], ")"}]}], ")"}]}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "b"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"b", " ", "c"}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
        RowBox[{"b", " ", 
         RowBox[{"Abs", "[", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], "]"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "-", "c"}], ")"}], " ", 
        SuperscriptBox["c", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"b", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{"b", "-", "c"}], ")"}]}], "+", 
          RowBox[{"Abs", "[", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], "]"}]}], ")"}]}], ")"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"a", "+", "b", "-", "c"}], ")"}], " ", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947495941558605*^9, 3.94758670416848*^9},
 CellLabel->
  "Out[198]=",ExpressionUUID->"1ad02fdd-360e-f347-a6cd-b3de99da69ec"]
}, Open  ]],

Cell["persp[ABCD, GHEF]", "Subsubsection",
 CellChangeTimes->{{3.946480913979744*^9, 3.946480925928507*^9}, {
  3.947586706796484*^9, 
  3.947586709228815*^9}},ExpressionUUID->"6868747d-3f40-1649-83f9-\
05a3d48fd7c7"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"PerspectiveQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}]}], "]"}], 
   ",", "bitrap"}], "]"}]], "Input",
 CellChangeTimes->{{3.9464841669171715`*^9, 3.946484167565193*^9}, {
  3.946545842952635*^9, 3.9465458517767544`*^9}, {3.947495937860609*^9, 
  3.9474959434904385`*^9}},
 CellLabel->
  "In[199]:=",ExpressionUUID->"a5633397-214a-064e-9ebb-5e94978088ef"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946484168532686*^9, 3.946545810984468*^9, 
  3.946545852725073*^9, 3.946552351647703*^9, 3.94655242841027*^9, 
  3.947495944331465*^9, 3.9475867110851097`*^9},
 CellLabel->
  "Out[199]=",ExpressionUUID->"8d81fe1b-0248-924e-830a-9b5297a841a1"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (56) ", "Subsection",
 CellChangeTimes->{{3.94647886735042*^9, 3.946478870724262*^9}, {
   3.946484241605079*^9, 3.946484242732435*^9}, 3.946545890008735*^9, {
   3.9474957993387833`*^9, 3.947495801730276*^9}, 3.947496234250189*^9, 
   3.9475867441793003`*^9},ExpressionUUID->"8162f58e-cebe-8b42-addc-\
616c9668dd6c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"CentralQuadrilateral", "[", "56", "]"}], ",", "bitrap"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.947495998866066*^9, {3.94749619994623*^9, 3.947496208697859*^9}},
 CellLabel->
  "In[200]:=",ExpressionUUID->"fe97a52c-c48d-3745-9e74-2c33e1bf096c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"b", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "b", " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "3"], "-", 
         RowBox[{"b", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "a"}], "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "3"]}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", "b", " ", "c"}], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        SuperscriptBox["c", "4"], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "b", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"b", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"2", " ", "a", " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", "c"}], ")"}], " ", 
      SuperscriptBox["c", "2"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947495999505871*^9, 3.947496034880438*^9, 
  3.947496077254553*^9, 3.947496210106907*^9, 3.9475867288983784`*^9},
 CellLabel->
  "Out[200]=",ExpressionUUID->"a9a986b7-fd80-7048-95c3-c65e091bcad9"]
}, Open  ]],

Cell["persp[ABCD, GHEF]", "Subsubsection",
 CellChangeTimes->{{3.946480913979744*^9, 3.946480925928507*^9}, {
  3.9475867314759865`*^9, 
  3.9475867337723045`*^9}},ExpressionUUID->"5600e1d2-219e-9e47-a2eb-\
208e4df03122"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"PerspectiveQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}]}], "]"}], 
   ",", "bitrap"}], "]"}]], "Input",
 CellChangeTimes->{{3.9464841669171715`*^9, 3.946484167565193*^9}, {
  3.9464842013325796`*^9, 3.9464842017168617`*^9}, {3.946545854816831*^9, 
  3.946545862073334*^9}, {3.947495996261057*^9, 3.947496001402836*^9}},
 CellLabel->
  "In[201]:=",ExpressionUUID->"c93c069f-e9a0-7843-b3bc-1f354e62ef44"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946484202374287*^9, 3.946545813875395*^9, 
  3.9465458628786907`*^9, 3.9465523592104664`*^9, 3.946552437431053*^9, 
  3.947496002115595*^9, 3.947496212217448*^9, 3.947586734940813*^9},
 CellLabel->
  "Out[201]=",ExpressionUUID->"0aa77088-61ce-2e40-8d87-a9d2a34036d1"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (63)", "Subsection",
 CellChangeTimes->{{3.946478898766161*^9, 3.946478904220325*^9}, {
   3.9474965190573616`*^9, 3.947496519665365*^9}, {3.947496641673111*^9, 
   3.947496642072874*^9}, 3.947496830600744*^9, 
   3.947586771500143*^9},ExpressionUUID->"ecf41c4d-6006-3e4b-8cb1-\
077ce99b635c"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"CentralQuadrilateral", "[", "63", "]"}], ",", "bitrap"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.947496586105816*^9, {3.9474966488417196`*^9, 3.9474966610650196`*^9}},
 CellLabel->
  "In[202]:=",ExpressionUUID->"6c96383e-9bad-db40-85c9-29e76a67c9ac"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"a", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{
         SuperscriptBox["c", "3"], " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "3"]}], " ", "b"}], "-", 
      SuperscriptBox["b", "4"], "+", 
      SuperscriptBox["c", "4"], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{"a", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "3"], "-", 
         RowBox[{"b", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"2", " ", "b", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"3", " ", "a", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        SuperscriptBox["c", "3"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "4"], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "a", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
         SuperscriptBox["c", "3"]}], ")"}], "2"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", "a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"a", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "b", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "a", " ", 
      SuperscriptBox["c", "2"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.947496586782467*^9, {3.947496649929682*^9, 3.947496662197279*^9}, 
   3.947586757830559*^9},
 CellLabel->
  "Out[202]=",ExpressionUUID->"48df5f7d-c3de-7947-9ecd-16a0f50864b9"]
}, Open  ]],

Cell["persp[ABCD, HGFE]", "Subsubsection",
 CellChangeTimes->{{3.946480958971756*^9, 3.9464809648964844`*^9}, {
  3.9475867601239147`*^9, 
  3.947586762427536*^9}},ExpressionUUID->"b3578f1b-396a-4f49-8b3e-\
8a7cf8232f5a"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"PerspectiveQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptH", ",", "ptG", ",", "ptF", ",", "ptE"}], "}"}]}], "]"}], 
   ",", "bitrap"}], "]"}]], "Input",
 CellChangeTimes->{{3.946484375956259*^9, 3.946484388812689*^9}, {
  3.946484743732359*^9, 3.946484745051697*^9}, {3.946484944236145*^9, 
  3.946484944315735*^9}, {3.9474965839636345`*^9, 3.947496591649502*^9}, {
  3.947496677137589*^9, 3.947496684889131*^9}},
 CellLabel->
  "In[203]:=",ExpressionUUID->"d8ec441d-459e-5046-a6d0-3df636bb103d"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.946484389862408*^9, 3.9464847461500416`*^9, 3.946484945088333*^9, 
   3.94654603179298*^9, 3.947496600502594*^9, {3.947496664969116*^9, 
   3.947496685606348*^9}, 3.9475867634869347`*^9},
 CellLabel->
  "Out[203]=",ExpressionUUID->"31a058dc-057a-3a41-9e00-de1a9805b172"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (92)", "Subsection",
 CellChangeTimes->{{3.946478898766161*^9, 3.946478904220325*^9}, {
   3.9474965190573616`*^9, 3.947496519665365*^9}, {3.94749684942482*^9, 
   3.947496849969507*^9}, 3.947497181959837*^9, 
   3.947586797547865*^9},ExpressionUUID->"25ffaade-b49d-bd48-ad38-\
0be379197bbe"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"CentralQuadrilateral", "[", "92", "]"}], ",", "bitrap"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.947496586105816*^9, {3.947496856024496*^9, 3.94749686746436*^9}},
 CellLabel->
  "In[204]:=",ExpressionUUID->"57da1e63-ed71-254a-812b-9649f0307946"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "3"], " ", "b", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"4", " ", "b", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "-", 
           RowBox[{"12", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"19", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "a", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "5"], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
        RowBox[{
         SuperscriptBox["a", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "3"]}], "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "4"]}], " ", "c"}], "+", 
        SuperscriptBox["c", "5"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "4"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "a", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "3"], " ", "b", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["a", "2"], "-", 
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"a", " ", 
            SuperscriptBox["c", "5"]}], "-", 
           RowBox[{
            SuperscriptBox["b", "4"], " ", "c", " ", 
            RowBox[{"(", 
             RowBox[{"a", "+", 
              RowBox[{"2", " ", "c"}]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"a", "-", "b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"4", " ", "b", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "6"], "-", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "a"}], "+", "c"}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", "a"}], "+", 
           RowBox[{"9", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"22", " ", "a"}], "+", 
           RowBox[{"9", " ", "c"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "b"}], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "4"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "a"}], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        SuperscriptBox["b", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "4"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "a"}], " ", "b", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["b", "4"], "-", 
        SuperscriptBox["c", "4"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.947496586782467*^9, {3.94749685759285*^9, 3.947496868770651*^9}, 
   3.947586783064541*^9},
 CellLabel->
  "Out[204]=",ExpressionUUID->"7970a562-4d3d-d241-892e-1aada7df8460"]
}, Open  ]],

Cell["persp[ABCD, HGFE]", "Subsubsection",
 CellChangeTimes->{{3.946480958971756*^9, 3.9464809648964844`*^9}, {
  3.947586784995384*^9, 
  3.947586787443428*^9}},ExpressionUUID->"ccd0a6e1-05a2-8640-aea4-\
20d6bab04ca6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"PerspectiveQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptH", ",", "ptG", ",", "ptF", ",", "ptE"}], "}"}]}], "]"}], 
   ",", "bitrap"}], "]"}]], "Input",
 CellChangeTimes->{{3.946484375956259*^9, 3.946484388812689*^9}, {
  3.946484743732359*^9, 3.946484745051697*^9}, {3.946484944236145*^9, 
  3.946484944315735*^9}, {3.9474965839636345`*^9, 3.947496591649502*^9}, {
  3.947496877473418*^9, 3.947496883193189*^9}},
 CellLabel->
  "In[205]:=",ExpressionUUID->"715a8371-20a1-3348-a675-8de265d70a8b"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.946484389862408*^9, 3.9464847461500416`*^9, 3.946484945088333*^9, 
   3.94654603179298*^9, 3.947496600502594*^9, {3.947496872268191*^9, 
   3.947496884222969*^9}, 3.9475867886156693`*^9},
 CellLabel->
  "Out[205]=",ExpressionUUID->"593d2162-7189-004b-a850-f3984719b8c3"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (186)", "Subsection",
 CellChangeTimes->{{3.946478898766161*^9, 3.946478904220325*^9}, {
  3.9474965190573616`*^9, 3.947496519665365*^9}, {3.94749719498357*^9, 
  3.9474971955519466`*^9}},ExpressionUUID->"353ebd32-2929-5b48-8c60-\
6cbc952596ea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "186", "]"}]}]], "Input",
 CellChangeTimes->{
  3.947496586105816*^9, {3.947497201896124*^9, 3.9474972039678802`*^9}},
 CellLabel->
  "In[206]:=",ExpressionUUID->"d5e08ff4-af4b-6e46-9893-b28f591f95f6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"b", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "3"], "-", 
           RowBox[{"b", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}], "2"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
           SuperscriptBox["c", "3"]}], ")"}], "2"], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "4"]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           SuperscriptBox["c", "4"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "6"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "-", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "4"], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "4"], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           SuperscriptBox["c", "4"]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "6"], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        RowBox[{"a", " ", "b"}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        RowBox[{"a", " ", "b"}], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"b", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"b", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "-", 
        RowBox[{"a", " ", "b"}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        RowBox[{"a", " ", "b"}], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947496586782467*^9, 3.9474972047326193`*^9, 
  3.947586812898876*^9},
 CellLabel->
  "Out[206]=",ExpressionUUID->"a58c6b26-7591-774f-b83b-e5c135d1793d"]
}, Open  ]],

Cell["persp[ABCD, HGFE]", "Subsubsection",
 CellChangeTimes->{{3.946480958971756*^9, 3.9464809648964844`*^9}, {
  3.9475868154278984`*^9, 
  3.9475868179239845`*^9}},ExpressionUUID->"e94d0c2c-dee5-8846-a01e-\
bf8b42a5c175"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerspectiveQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"ptH", ",", "ptG", ",", "ptF", ",", "ptE"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.946484375956259*^9, 3.946484388812689*^9}, {
  3.946484743732359*^9, 3.946484745051697*^9}, {3.946484944236145*^9, 
  3.946484944315735*^9}, {3.9474965839636345`*^9, 3.947496591649502*^9}},
 CellLabel->
  "In[207]:=",ExpressionUUID->"1f448385-8da4-b64a-bd7d-ed117554f4d9"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946484389862408*^9, 3.9464847461500416`*^9, 
  3.946484945088333*^9, 3.94654603179298*^9, 3.947496600502594*^9, 
  3.947497208974249*^9, 3.947586819040636*^9},
 CellLabel->
  "Out[207]=",ExpressionUUID->"a842f168-6e52-d44b-b0c6-e3b05193f487"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (145) ", "Subsection",
 CellChangeTimes->{{3.94647886735042*^9, 3.946478870724262*^9}, {
   3.946484241605079*^9, 3.946484242732435*^9}, 3.946545890008735*^9, {
   3.947495804866747*^9, 3.947495806786877*^9}, 3.947496364137812*^9, 
   3.947586831692169*^9},ExpressionUUID->"26d63e37-acda-634b-912a-\
9b26c0fd603f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"CentralQuadrilateral", "[", "145", "]"}], ",", "bitrap"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.9474962860581284`*^9, 3.947496300146433*^9}},
 CellLabel->
  "In[208]:=",ExpressionUUID->"e7f67593-6745-1a47-84b4-1f86c2355c73"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", "a"}], "-", "b", "-", "c"}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}], "-", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", 
           RowBox[{"2", " ", "c"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "a", " ", "b"}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"5", " ", "a", " ", "c"}], "-", 
        RowBox[{"b", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "-", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", "b"}], "+", "c"}], ")"}]}]}], ")"}]}], 
     ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["b", "3"]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"2", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"b", " ", "c"}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["c", "2"], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{"b", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "3"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"b", " ", "c"}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "-", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"b", "+", "c"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "+", 
          RowBox[{"a", " ", 
           RowBox[{"(", 
            RowBox[{"b", "-", 
             RowBox[{"3", " ", "c"}]}], ")"}]}], "-", 
          SuperscriptBox["c", "2"]}], ")"}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", "a"}], "-", "b", "-", "c"}], ",", 
     RowBox[{
      RowBox[{"-", "a"}], "+", 
      RowBox[{"3", " ", "b"}], "-", "c"}], ",", 
     RowBox[{
      RowBox[{"-", "a"}], "-", "b", "+", 
      RowBox[{"3", " ", "c"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9474962865952015`*^9, 3.947496301573541*^9}, 
   3.9475868330563736`*^9},
 CellLabel->
  "Out[208]=",ExpressionUUID->"267fbcea-c65e-1247-b7f7-13614d1822d3"]
}, Open  ]],

Cell["persp[ABCD, GHEF]", "Subsubsection",
 CellChangeTimes->{{3.946480913979744*^9, 3.946480925928507*^9}, {
  3.94758683587599*^9, 
  3.947586838147316*^9}},ExpressionUUID->"6aa558f6-c645-004b-b224-\
c24abf383866"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"PerspectiveQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}]}], "]"}], 
   ",", "bitrap"}], "]"}]], "Input",
 CellChangeTimes->{{3.9464841669171715`*^9, 3.946484167565193*^9}, {
  3.946484211861243*^9, 3.946484213044567*^9}, {3.946545868464025*^9, 
  3.946545875048065*^9}, {3.947496283787405*^9, 3.947496303954479*^9}},
 CellLabel->
  "In[209]:=",ExpressionUUID->"a063d7ab-ebce-844e-ae0a-9297a16b02cd"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946484213953739*^9, 3.9465458758800507`*^9, 
  3.946552364956772*^9, 3.946552446832723*^9, 3.9474963046235466`*^9, 
  3.9475868394034023`*^9},
 CellLabel->
  "Out[209]=",ExpressionUUID->"5ff13691-eef0-654e-8fd6-2c4636160c05"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (265)", "Subsection",
 CellChangeTimes->{{3.946478898766161*^9, 3.946478904220325*^9}, {
   3.9474965190573616`*^9, 3.947496519665365*^9}, {3.9474972412714167`*^9, 
   3.9474972415994062`*^9}, 3.947497670006941*^9, {3.9475868724032593`*^9, 
   3.947586873755535*^9}},ExpressionUUID->"bdc5cdc9-8746-324d-9b9d-\
c8d522ced518"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"CentralQuadrilateral", "[", "265", "]"}], ",", "bitrap"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.947496586105816*^9, {3.9474972482958817`*^9, 3.947497260633002*^9}},
 CellLabel->
  "In[210]:=",ExpressionUUID->"f0eaf5f7-f2af-434a-ba83-9b0a2c1f96df"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "4"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"a", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"2", " ", "c"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"7", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "10"], "+", 
        RowBox[{
         SuperscriptBox["b", "8"], " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "a"}], "+", 
           RowBox[{"9", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{"8", " ", 
         SuperscriptBox["c", "9"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"70", " ", "a"}], "+", 
           RowBox[{"29", " ", "c"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"58", " ", "a"}], "+", 
           RowBox[{"137", " ", "c"}]}], ")"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "7"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"216", " ", "a"}], "+", 
           RowBox[{"139", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"411", " ", "a"}], "+", 
           RowBox[{"451", " ", "c"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"8", " ", 
         SuperscriptBox["b", "8"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "6"], " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", "a"}], "+", 
           RowBox[{"17", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"46", " ", "a"}], "+", 
           RowBox[{"47", " ", "c"}]}], ")"}]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"113", " ", "a"}], "+", 
           RowBox[{"70", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "7"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"199", " ", "a"}], "+", 
           RowBox[{"82", " ", "c"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"8", " ", 
         SuperscriptBox["b", "12"]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "10"], " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"12", " ", "a"}], "+", 
           RowBox[{"37", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "9"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", "a"}], "+", 
           RowBox[{"74", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "8"], " ", 
         SuperscriptBox["c", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"128", " ", "a"}], "+", 
           RowBox[{"187", " ", "c"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["c", "11"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"1019", " ", "a"}], "+", 
           RowBox[{"422", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "7"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2095", " ", "a"}], "+", 
           RowBox[{"906", " ", "c"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"1757", " ", "a"}], "+", 
           RowBox[{"1462", " ", "c"}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"7", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "12"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"40", " ", "a"}], "-", 
           RowBox[{"33", " ", "c"}]}], ")"}], " ", 
         SuperscriptBox["c", "9"]}], "-", 
        RowBox[{"8", " ", 
         SuperscriptBox["c", "11"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"70", " ", "a"}], "+", 
           RowBox[{"29", " ", "c"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "10"], " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"11", " ", "a"}], "+", 
           RowBox[{"42", " ", "c"}]}], ")"}]}], "-", 
        RowBox[{"11", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"67", " ", "a"}], "+", 
           RowBox[{"62", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "8"], " ", 
         SuperscriptBox["c", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"169", " ", "a"}], "+", 
           RowBox[{"284", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "7"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"1107", " ", "a"}], "+", 
           RowBox[{"539", " ", "c"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "a", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", "c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"2", " ", "c"}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"23", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"28", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "6"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["b", "4"], " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"2", " ", "c"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["c", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"29", " ", "a"}], "+", 
           RowBox[{"12", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"26", " ", "a"}], "+", 
           RowBox[{"21", " ", "c"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", "a", " ", "c"}], "+", 
        RowBox[{"b", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", "a", " ", "c"}], "+", 
        RowBox[{"b", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "a", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", "a", " ", "c"}], "+", 
        RowBox[{"b", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", "a", " ", "c"}], "+", 
        RowBox[{"b", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"2", " ", "c"}]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.947496586782467*^9, {3.947497249741884*^9, 3.9474972622224917`*^9}, 
   3.9475868528551865`*^9},
 CellLabel->
  "Out[210]=",ExpressionUUID->"6ada0d69-d742-b64a-a4ad-20330c7ae2b7"]
}, Open  ]],

Cell["persp[ABCD, HGFE]", "Subsubsection",
 CellChangeTimes->{{3.946480958971756*^9, 3.9464809648964844`*^9}, {
  3.947586858523487*^9, 
  3.9475868613720055`*^9}},ExpressionUUID->"958d8a62-f0cb-854b-a30a-\
002c787d1863"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"PerspectiveQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptH", ",", "ptG", ",", "ptF", ",", "ptE"}], "}"}]}], "]"}], 
   ",", "bitrap"}], "]"}]], "Input",
 CellChangeTimes->{{3.946484375956259*^9, 3.946484388812689*^9}, {
  3.946484743732359*^9, 3.946484745051697*^9}, {3.946484944236145*^9, 
  3.946484944315735*^9}, {3.9474965839636345`*^9, 3.947496591649502*^9}, {
  3.9474972736162643`*^9, 3.947497280511999*^9}},
 CellLabel->
  "In[211]:=",ExpressionUUID->"f06af811-0844-934e-b55e-a9cd57a4fa42"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.946484389862408*^9, 3.9464847461500416`*^9, 3.946484945088333*^9, 
   3.94654603179298*^9, 3.947496600502594*^9, {3.94749726935853*^9, 
   3.94749728138237*^9}, 3.947586863060831*^9},
 CellLabel->
  "Out[211]=",ExpressionUUID->"2b65a913-5bc3-924c-a65f-7fdc9d8b389e"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (304)", "Subsection",
 CellChangeTimes->{{3.946478898766161*^9, 3.946478904220325*^9}, {
   3.9474965190573616`*^9, 3.947496519665365*^9}, {3.947497688567026*^9, 
   3.947497689422617*^9}, 3.947497852183148*^9, 
   3.947586908988409*^9},ExpressionUUID->"a5b9d6f0-5337-474c-87dd-\
249e4f8834a8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"CentralQuadrilateral", "[", "304", "]"}], ",", "bitrap"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.947496586105816*^9, {3.947497693871437*^9, 3.947497706295347*^9}},
 CellLabel->
  "In[212]:=",ExpressionUUID->"447a603a-a4e3-4540-b55c-fb04074ea1d7"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "2"], " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"a", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "b", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "3"}], " ", "a", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"11", " ", "a", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"5", " ", 
         SuperscriptBox["c", "3"]}]}], ")"}]}], ",", 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "5"], "+", 
        SuperscriptBox["b", "5"], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "3"]}], "+", 
           RowBox[{"b", " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "2"]}], "+", 
         SuperscriptBox["c", "2"]}], ")"}], "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", "c", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"c", " ", 
          RowBox[{"(", 
           RowBox[{"a", "+", "c"}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", "b", " ", "c", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "+", 
            SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"2", " ", "b", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", " ", 
         SuperscriptBox["b", "6"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"10", " ", "a"}], "+", "c"}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["c", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"13", " ", "a"}], "+", 
           RowBox[{"5", " ", "c"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"7", " ", "a"}], "+", 
           RowBox[{"9", " ", "c"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "a", " ", "c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", "b", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"a", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"a", " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", "b", " ", "c"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.947496586782467*^9, {3.9474976955827484`*^9, 3.947497707316494*^9}, 
   3.9475868892961235`*^9},
 CellLabel->
  "Out[212]=",ExpressionUUID->"b1d428d9-cdff-0348-9d71-cf4f3787836b"]
}, Open  ]],

Cell["persp[ABCD, HGFE]", "Subsubsection",
 CellChangeTimes->{{3.946480958971756*^9, 3.9464809648964844`*^9}, {
  3.947586891515772*^9, 
  3.947586893755371*^9}},ExpressionUUID->"c2c5adb2-eab2-bf45-ad1a-\
9a670e6db80d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"PerspectiveQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptH", ",", "ptG", ",", "ptF", ",", "ptE"}], "}"}]}], "]"}], 
   ",", "bitrap"}], "]"}]], "Input",
 CellChangeTimes->{{3.946484375956259*^9, 3.946484388812689*^9}, {
  3.946484743732359*^9, 3.946484745051697*^9}, {3.946484944236145*^9, 
  3.946484944315735*^9}, {3.9474965839636345`*^9, 3.947496591649502*^9}, {
  3.947497714383343*^9, 3.947497720967037*^9}},
 CellLabel->
  "In[214]:=",ExpressionUUID->"2105c51b-b181-ae44-95e7-7b4bde0d1e37"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.946484389862408*^9, 3.9464847461500416`*^9, 3.946484945088333*^9, 
   3.94654603179298*^9, 3.947496600502594*^9, {3.947497712251864*^9, 
   3.947497722006619*^9}, {3.9475868948126793`*^9, 3.947586906335169*^9}},
 CellLabel->
  "Out[214]=",ExpressionUUID->"5fbf4186-2143-934b-95de-50afdb08cd37"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (305)", "Subsection",
 CellChangeTimes->{{3.946478898766161*^9, 3.946478904220325*^9}, {
  3.9474965190573616`*^9, 3.947496519665365*^9}, {3.9474978680947857`*^9, 
  3.9474978686551666`*^9}},ExpressionUUID->"611c64c4-50b0-f446-b80f-\
43bf368bf2c6"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "305", "]"}]}]], "Input",
 CellChangeTimes->{
  3.947496586105816*^9, {3.947497874150452*^9, 3.9474978746709356`*^9}},
 CellLabel->
  "In[215]:=",ExpressionUUID->"5789f6fa-53c5-1a4d-a44a-5cd8db562c48"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "-", 
        RowBox[{
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "6"], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "6"], "+", 
        SuperscriptBox["b", "6"], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "4"]}], "+", 
           RowBox[{
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "2"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "4"], " ", 
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["c", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "4"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "5"], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "3"], "-", 
            RowBox[{"b", " ", 
             SuperscriptBox["c", "2"]}]}], ")"}], "2"]}]}], ")"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["b", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "4"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "5"], "-", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SuperscriptBox["b", "2"]}], " ", "c"}], "+", 
            SuperscriptBox["c", "3"]}], ")"}], "2"]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "4"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["a", "2"]}], "+", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947496586782467*^9, 3.947497875344446*^9, 
  3.947586916375414*^9},
 CellLabel->
  "Out[215]=",ExpressionUUID->"01948c3a-bc7b-cd49-8792-9cdea4826a15"]
}, Open  ]],

Cell["persp[ABCD, HGFE]", "Subsubsection",
 CellChangeTimes->{{3.946480958971756*^9, 3.9464809648964844`*^9}, {
  3.947586918915825*^9, 
  3.9475869212845936`*^9}},ExpressionUUID->"dcfab937-bfaa-a246-a446-\
61b1a490bf6b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerspectiveQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"ptH", ",", "ptG", ",", "ptF", ",", "ptE"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.946484375956259*^9, 3.946484388812689*^9}, {
  3.946484743732359*^9, 3.946484745051697*^9}, {3.946484944236145*^9, 
  3.946484944315735*^9}, {3.9474965839636345`*^9, 3.947496591649502*^9}},
 CellLabel->
  "In[216]:=",ExpressionUUID->"bea49425-a0b6-604f-8c87-195ac42b3bf9"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946484389862408*^9, 3.9464847461500416`*^9, 
  3.946484945088333*^9, 3.94654603179298*^9, 3.947496600502594*^9, 
  3.9474978794410686`*^9, 3.9475869223093357`*^9},
 CellLabel->
  "Out[216]=",ExpressionUUID->"aa93d1c4-dad5-ed42-b187-08022f45d39c"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (317)", "Subsection",
 CellChangeTimes->{{3.946478898766161*^9, 3.946478904220325*^9}, {
  3.9474965190573616`*^9, 3.947496519665365*^9}, {3.947497909926319*^9, 
  3.9474979106299934`*^9}},ExpressionUUID->"acfccc66-81e9-9b42-acc8-\
f7cd3d3f0c21"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "317", "]"}]}]], "Input",
 CellChangeTimes->{
  3.947496586105816*^9, {3.947497915383097*^9, 3.9474979167588024`*^9}},
 CellLabel->
  "In[217]:=",ExpressionUUID->"a95f8b12-342b-194b-bc9a-da7c6800d0c6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "8"], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "6"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "4"], "+", 
             SuperscriptBox["c", "4"]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "2"]}], "+", 
             RowBox[{"6", " ", 
              SuperscriptBox["c", "4"]}]}], ")"}]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "6"], "-", 
             RowBox[{
              SuperscriptBox["b", "4"], " ", 
              SuperscriptBox["c", "2"]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "4"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "8"], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "6"], " ", 
           SuperscriptBox["b", "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"6", " ", 
              SuperscriptBox["b", "4"]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "4"], "+", 
             SuperscriptBox["c", "4"]}], ")"}]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "6"]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["b", "4"], " ", 
              SuperscriptBox["c", "2"]}], "-", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "4"]}], "+", 
             SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}], ")"}]}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "+", 
            SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], "2"]}], ",", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "4"}], " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["b", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "4"]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "6"], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "4"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"3", " ", 
              SuperscriptBox["b", "2"]}], "-", 
             SuperscriptBox["c", "2"]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "3"], "-", 
              RowBox[{"b", " ", 
               SuperscriptBox["c", "2"]}]}], ")"}], "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "8"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "4"], "+", 
             SuperscriptBox["c", "4"]}], ")"}]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", 
              SuperscriptBox["b", "6"]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["b", "4"], " ", 
              SuperscriptBox["c", "2"]}], "-", 
             RowBox[{
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "4"]}], "+", 
             SuperscriptBox["c", "6"]}], ")"}]}]}], ")"}]}], ")"}]}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"], "-", 
         RowBox[{
          SuperscriptBox["a", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "+", 
            SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], "2"]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           SuperscriptBox["a", "4"], " ", 
           SuperscriptBox["c", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"3", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["c", "2"], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "4"]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "6"], "+", 
          RowBox[{
           SuperscriptBox["a", "8"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "4"], "+", 
             SuperscriptBox["c", "4"]}], ")"}]}], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "6"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "6"], "-", 
             RowBox[{
              SuperscriptBox["b", "4"], " ", 
              SuperscriptBox["c", "2"]}], "-", 
             RowBox[{"2", " ", 
              SuperscriptBox["b", "2"], " ", 
              SuperscriptBox["c", "4"]}], "+", 
             RowBox[{"2", " ", 
              SuperscriptBox["c", "6"]}]}], ")"}]}]}], ")"}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"b", "-", "c"}], ")"}], "2"]}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "+", 
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["b", "2"]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}], ")"}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "4"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["a", "2"], " ", 
           SuperscriptBox["c", "2"]}], "+", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}], ")"}]}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.947496586782467*^9, 3.947497917409426*^9, 
  3.9475869344727535`*^9},
 CellLabel->
  "Out[217]=",ExpressionUUID->"020cf8fb-a8ba-a141-a999-d45b56e45d24"]
}, Open  ]],

Cell["persp[ABCD, HGFE]", "Subsubsection",
 CellChangeTimes->{{3.946480958971756*^9, 3.9464809648964844`*^9}, {
  3.947586937227762*^9, 
  3.9475869398038425`*^9}},ExpressionUUID->"770dd665-cc10-7245-a242-\
3741a759ae7d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PerspectiveQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"ptH", ",", "ptG", ",", "ptF", ",", "ptE"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.946484375956259*^9, 3.946484388812689*^9}, {
  3.946484743732359*^9, 3.946484745051697*^9}, {3.946484944236145*^9, 
  3.946484944315735*^9}, {3.9474965839636345`*^9, 3.947496591649502*^9}},
 CellLabel->
  "In[218]:=",ExpressionUUID->"9d2277a4-f0c9-504f-bfa7-ccb6cde2ad71"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.946484389862408*^9, 3.9464847461500416`*^9, 
  3.946484945088333*^9, 3.94654603179298*^9, 3.947496600502594*^9, 
  3.9474979216580315`*^9, 3.9475869409581223`*^9},
 CellLabel->
  "Out[218]=",ExpressionUUID->"90a2ef84-a9cc-ed44-903a-eef04d45d317"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (328)", "Subsection",
 CellChangeTimes->{{3.946478898766161*^9, 3.946478904220325*^9}, {
  3.9474965190573616`*^9, 3.947496519665365*^9}, {3.947497939766271*^9, 
  3.947497940702559*^9}, {3.9474990345471287`*^9, 3.947499037628563*^9}, {
  3.9475869750673256`*^9, 
  3.947586976579771*^9}},ExpressionUUID->"34c17ba1-6ab0-3e42-9e67-\
0fe0854ddf0d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"CentralQuadrilateral", "[", "328", "]"}], ",", "bitrap"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.947496586105816*^9, {3.9474979471352186`*^9, 3.9474979610707684`*^9}},
 CellLabel->
  "In[219]:=",ExpressionUUID->"57764ba9-1a85-c944-9db0-85a70fb248b1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "4"], " ", 
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", "a", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"2", " ", "c"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"15", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"14", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"31", " ", 
         SuperscriptBox["b", "8"], " ", "c"}], "-", 
        RowBox[{"385", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{"1373", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "5"]}], "-", 
        RowBox[{"1811", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "7"]}], "+", 
        RowBox[{"792", " ", 
         SuperscriptBox["c", "9"]}], "+", 
        RowBox[{"4", " ", "a", " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "8"], "-", 
           RowBox[{"41", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"295", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"685", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"478", " ", 
            SuperscriptBox["c", "8"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["c", "3"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"98", " ", 
         SuperscriptBox["b", "10"], " ", "c"}], "-", 
        RowBox[{"1073", " ", 
         SuperscriptBox["b", "8"], " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{"4271", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "5"]}], "-", 
        RowBox[{"7927", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "7"]}], "+", 
        RowBox[{"6939", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "9"]}], "-", 
        RowBox[{"2308", " ", 
         SuperscriptBox["c", "11"]}], "+", 
        RowBox[{"4", " ", "a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"4", " ", 
            SuperscriptBox["b", "10"]}], "-", 
           RowBox[{"120", " ", 
            SuperscriptBox["b", "8"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"835", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"2373", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"2999", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "8"]}], "-", 
           RowBox[{"1393", " ", 
            SuperscriptBox["c", "10"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "4"], " ", "c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "a", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["b", "4"], " ", "c"}], "-", 
        RowBox[{"26", " ", "a", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"21", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{"28", " ", "a", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["c", "5"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "4"], " ", 
      SuperscriptBox["c", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "4"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["c", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"4", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"94", " ", 
         SuperscriptBox["b", "14"], " ", "c"}], "-", 
        RowBox[{"1123", " ", 
         SuperscriptBox["b", "12"], " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{"4705", " ", 
         SuperscriptBox["b", "10"], " ", 
         SuperscriptBox["c", "5"]}], "-", 
        RowBox[{"8266", " ", 
         SuperscriptBox["b", "8"], " ", 
         SuperscriptBox["c", "7"]}], "+", 
        RowBox[{"4336", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "9"]}], "+", 
        RowBox[{"3193", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "11"]}], "-", 
        RowBox[{"3007", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "13"]}], "+", 
        RowBox[{"68", " ", 
         SuperscriptBox["c", "15"]}], "+", 
        RowBox[{"2", " ", "a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", 
            SuperscriptBox["b", "14"]}], "-", 
           RowBox[{"242", " ", 
            SuperscriptBox["b", "12"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"1801", " ", 
            SuperscriptBox["b", "10"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"5246", " ", 
            SuperscriptBox["b", "8"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"5566", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "8"]}], "+", 
           RowBox[{"822", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "10"]}], "-", 
           RowBox[{"3559", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "12"]}], "+", 
           RowBox[{"82", " ", 
            SuperscriptBox["c", "14"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "4"], " ", "c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", "a", " ", 
         SuperscriptBox["b", "4"]}], "+", 
        RowBox[{"9", " ", 
         SuperscriptBox["b", "4"], " ", "c"}], "-", 
        RowBox[{"26", " ", "a", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"21", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{"28", " ", "a", " ", 
         SuperscriptBox["c", "4"]}], "+", 
        RowBox[{"12", " ", 
         SuperscriptBox["c", "5"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"7", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "3"], "-", 
         RowBox[{"b", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"17", " ", 
         SuperscriptBox["b", "12"], " ", "c"}], "-", 
        RowBox[{"133", " ", 
         SuperscriptBox["b", "10"], " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{"514", " ", 
         SuperscriptBox["b", "8"], " ", 
         SuperscriptBox["c", "5"]}], "-", 
        RowBox[{"1338", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "7"]}], "+", 
        RowBox[{"1557", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "9"]}], "+", 
        RowBox[{"175", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "11"]}], "-", 
        RowBox[{"792", " ", 
         SuperscriptBox["c", "13"]}], "+", 
        RowBox[{"2", " ", "a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "12"]}], "-", 
           RowBox[{"37", " ", 
            SuperscriptBox["b", "10"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"196", " ", 
            SuperscriptBox["b", "8"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"630", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"1262", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "8"]}], "-", 
           RowBox[{"605", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "10"]}], "-", 
           RowBox[{"956", " ", 
            SuperscriptBox["c", "12"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "a", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], "4"], " ", "c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "4"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"2", " ", "c"}]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
        RowBox[{
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           RowBox[{"b", " ", "c"}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"4", " ", 
         SuperscriptBox["b", "4"]}], "-", 
        RowBox[{"23", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"28", " ", 
         SuperscriptBox["c", "4"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "6"], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["b", "4"], " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"2", " ", "c"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["c", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"29", " ", "a"}], "+", 
           RowBox[{"12", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"26", " ", "a"}], "+", 
           RowBox[{"21", " ", "c"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "4"]}], " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", "a", " ", "c"}], "-", 
        RowBox[{"b", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", "a", " ", "c"}], "+", 
        RowBox[{"b", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["a", "3"], " ", 
      SuperscriptBox["b", "2"], " ", "c", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", "a", " ", "c"}], "-", 
        RowBox[{"b", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", "a", " ", "c"}], "+", 
        RowBox[{"b", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"2", " ", "c"}]}], ")"}]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.947496586782467*^9, {3.947497949847733*^9, 3.947497962676813*^9}, 
   3.947586954611273*^9},
 CellLabel->
  "Out[219]=",ExpressionUUID->"69ba714c-74bb-d149-97a1-78e88798d907"]
}, Open  ]],

Cell["persp[ABCD, HGFE]", "Subsubsection",
 CellChangeTimes->{{3.946480958971756*^9, 3.9464809648964844`*^9}, {
  3.9475869609878273`*^9, 
  3.947586963411537*^9}},ExpressionUUID->"606b6d1d-be84-5f4a-8d6f-\
bf7c89cb0668"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"PerspectiveQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptH", ",", "ptG", ",", "ptF", ",", "ptE"}], "}"}]}], "]"}], 
   ",", "bitrap"}], "]"}]], "Input",
 CellChangeTimes->{{3.946484375956259*^9, 3.946484388812689*^9}, {
  3.946484743732359*^9, 3.946484745051697*^9}, {3.946484944236145*^9, 
  3.946484944315735*^9}, {3.9474965839636345`*^9, 3.947496591649502*^9}, {
  3.9474979705110416`*^9, 3.9474979782878237`*^9}},
 CellLabel->
  "In[221]:=",ExpressionUUID->"b9d481fb-186c-5744-a51a-2889d86fd1d1"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.946484389862408*^9, 3.9464847461500416`*^9, 3.946484945088333*^9, 
   3.94654603179298*^9, 3.947496600502594*^9, {3.947497967765209*^9, 
   3.947497979092758*^9}, {3.94758695624988*^9, 3.9475869649191113`*^9}},
 CellLabel->
  "Out[221]=",ExpressionUUID->"b7b5c811-02ec-6f40-9a28-5fa9467aedc8"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (382)", "Subsection",
 CellChangeTimes->{{3.946478848581734*^9, 
  3.9464788523878994`*^9}},ExpressionUUID->"d23d7d1f-17b4-254e-a768-\
a6c16b5b2671"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"CentralQuadrilateral", "[", "382", "]"}]}]], "Input",
 CellChangeTimes->{3.947495706811505*^9},
 CellLabel->
  "In[222]:=",ExpressionUUID->"d3da9c21-fac2-b449-a046-6e794cc9a19b"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["a", "6"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "4"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"]}]}], ")"}]}], ")"}]}], 
     ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "4"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4"}], " ", 
              SuperscriptBox["b", "2"]}], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ")"}]}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "6"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "4"]}]}], ")"}]}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "+", 
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "4"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "4"}], " ", 
              SuperscriptBox["b", "2"]}], "+", 
             SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ")"}]}]}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "6"], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["a", "2"], "-", 
          SuperscriptBox["b", "2"], "+", 
          SuperscriptBox["c", "2"]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["a", "4"]}], "+", 
          RowBox[{
           SuperscriptBox["a", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["b", "2"], "-", 
             RowBox[{"4", " ", 
              SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["b", "2"], "-", 
              SuperscriptBox["c", "2"]}], ")"}], "2"]}]}], ")"}]}], ")"}]}], 
     ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SuperscriptBox["b", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"5", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "2"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "+", 
         SuperscriptBox["c", "2"]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["c", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       SuperscriptBox["a", "4"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["b", "4"]}], "-", 
      RowBox[{
       SuperscriptBox["b", "2"], " ", 
       SuperscriptBox["c", "2"]}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["c", "4"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"]}], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.9474957074823294`*^9, 3.947495899748485*^9, 
  3.9475869879335823`*^9},
 CellLabel->
  "Out[222]=",ExpressionUUID->"d00cf80e-9936-7843-b6dc-f24429211d98"]
}, Open  ]],

Cell["homot[ABCD, EFGH]", "Subsubsection",
 CellChangeTimes->{{3.946480874075044*^9, 3.946480898624697*^9}, 
   3.9475869918273735`*^9},ExpressionUUID->"c252966a-0cc9-6749-8a08-\
1eae86d04058"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HomotheticQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.946483737452902*^9, 3.946483740173292*^9}, {
  3.9474956992768974`*^9, 3.9474957023548794`*^9}},
 CellLabel->
  "In[223]:=",ExpressionUUID->"f68b6529-731b-2e4f-9b5b-334ba7343e89"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9464837412137394`*^9, 3.946483774240631*^9, 
  3.9465457561943665`*^9, 3.947495709137209*^9, 3.947495900897774*^9, 
  3.9475869930017834`*^9},
 CellLabel->
  "Out[223]=",ExpressionUUID->"95581cfd-d846-0443-a0ac-3b393320ff2c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox[
  RowBox[{"CuadradoDistancia", "[", 
   RowBox[{"ptA", ",", "ptB"}], "]"}], 
  RowBox[{"CuadradoDistancia", "[", 
   RowBox[{"ptE", ",", "ptF"}], "]"}]]], "Input",
 CellChangeTimes->{{3.947587002302561*^9, 3.947587025444107*^9}},
 CellLabel->
  "In[224]:=",ExpressionUUID->"13374f17-2f1d-8042-a0a7-87ac867f97a7"],

Cell[BoxData[
 FractionBox["1", "4"]], "Output",
 CellChangeTimes->{3.9475870264234695`*^9},
 CellLabel->
  "Out[224]=",ExpressionUUID->"c8e37270-ed67-a047-810d-70091650c343"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (563)", "Subsection",
 CellChangeTimes->{{3.946478898766161*^9, 3.946478904220325*^9}, {
  3.9474965190573616`*^9, 3.947496519665365*^9}, {3.947497909926319*^9, 
  3.947497910629994*^9}, {3.947499160259695*^9, 3.947499161595997*^9}, {
  3.9474997162748756`*^9, 3.9474997240747013`*^9}, {3.9475870565466385`*^9, 
  3.9475870578992195`*^9}},ExpressionUUID->"e9744ba1-7fd4-074f-a5a8-\
fb26516a8451"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"CentralQuadrilateral", "[", "563", "]"}], ",", "bitrap"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{
  3.947496586105816*^9, {3.947497915383097*^9, 3.9474979167588024`*^9}, {
   3.94749916885142*^9, 3.947499186595686*^9}},
 CellLabel->
  "In[225]:=",ExpressionUUID->"8cafcb74-7d5b-bf44-914c-738ebce59c89"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", "a", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"10", " ", 
         SuperscriptBox["b", "10"], " ", "c"}], "-", 
        RowBox[{"79", " ", 
         SuperscriptBox["b", "8"], " ", 
         SuperscriptBox["c", "3"]}], "+", 
        RowBox[{"233", " ", 
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "5"]}], "-", 
        RowBox[{"325", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "7"]}], "+", 
        RowBox[{"215", " ", 
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "9"]}], "-", 
        RowBox[{"54", " ", 
         SuperscriptBox["c", "11"]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "10"]}], "-", 
           RowBox[{"43", " ", 
            SuperscriptBox["b", "8"], " ", 
            SuperscriptBox["c", "2"]}], "+", 
           RowBox[{"218", " ", 
            SuperscriptBox["b", "6"], " ", 
            SuperscriptBox["c", "4"]}], "-", 
           RowBox[{"450", " ", 
            SuperscriptBox["b", "4"], " ", 
            SuperscriptBox["c", "6"]}], "+", 
           RowBox[{"407", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "8"]}], "-", 
           RowBox[{"130", " ", 
            SuperscriptBox["c", "10"]}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["a", "6"]}], " ", 
       SuperscriptBox["b", "5"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "9"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["b", "5"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["b", "2"], "-", 
          SuperscriptBox["c", "2"]}], ")"}], "3"]}], "+", 
      RowBox[{
       SuperscriptBox["a", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "7"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "5"], " ", 
          SuperscriptBox["c", "2"]}]}], ")"}]}], "-", 
      RowBox[{"3", " ", 
       SuperscriptBox["a", "7"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "4"], "-", 
         SuperscriptBox["c", "4"]}], ")"}]}], "-", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", 
       SuperscriptBox["b", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "4"]}], "-", 
         RowBox[{"4", " ", 
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "2"]}], "+", 
         SuperscriptBox["c", "4"]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "5"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          SuperscriptBox["b", "6"]}], "+", 
         RowBox[{
          SuperscriptBox["b", "4"], " ", 
          SuperscriptBox["c", "2"]}], "-", 
         RowBox[{
          SuperscriptBox["b", "2"], " ", 
          SuperscriptBox["c", "4"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
      RowBox[{
       SuperscriptBox["a", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["b", "8"]}], "+", 
         SuperscriptBox["c", "8"]}], ")"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["a", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["b", "10"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "9"], " ", "c"}], "+", 
        RowBox[{"4", " ", "a", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "5"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "a"}], "-", 
           RowBox[{"2", " ", "c"}]}], ")"}], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "a"}], "-", 
           RowBox[{"2", " ", "c"}]}], ")"}], " ", 
         SuperscriptBox["c", "7"]}], "+", 
        RowBox[{"2", " ", "b", " ", 
         SuperscriptBox["c", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", "a"}], "+", 
           RowBox[{"2", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "9"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", "a"}], "+", 
           RowBox[{"2", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "8"], " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "a"}], "+", 
           RowBox[{"3", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "7"], " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "a"}], "+", 
           RowBox[{"3", " ", "c"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"17", " ", "a"}], "+", 
           RowBox[{"9", " ", "c"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "5"], " ", 
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"17", " ", "a"}], "+", 
           RowBox[{"9", " ", "c"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "3"]}], " ", 
      SuperscriptBox["b", "5"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "2"], "-", 
        SuperscriptBox["b", "2"], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"6", " ", "a", " ", "c", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             SuperscriptBox["b", "2"]}], "+", 
            SuperscriptBox["c", "2"]}], ")"}], "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["b", "2"], "-", 
            SuperscriptBox["c", "2"]}], ")"}], "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "8"}], " ", 
            SuperscriptBox["b", "11"]}], "+", 
           RowBox[{"44", " ", 
            SuperscriptBox["b", "9"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"72", " ", 
            SuperscriptBox["b", "7"], " ", 
            SuperscriptBox["c", "4"]}], "+", 
           RowBox[{"36", " ", 
            SuperscriptBox["b", "5"], " ", 
            SuperscriptBox["c", "6"]}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "6"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            SuperscriptBox["b", "8"]}], "+", 
           SuperscriptBox["c", "8"]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["a", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", 
            SuperscriptBox["b", "10"]}], "+", 
           RowBox[{"24", " ", 
            SuperscriptBox["b", "9"], " ", "c"}], "-", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "8"], " ", 
            SuperscriptBox["c", "2"]}], "-", 
           RowBox[{"92", " ", 
            SuperscriptBox["b", "7"], " ", 
            SuperscriptBox["c", "3"]}], "+", 
           RowBox[{"84", " ", 
            SuperscriptBox["b", "5"], " ", 
            SuperscriptBox["c", "5"]}], "+", 
           RowBox[{"5", " ", 
            SuperscriptBox["b", "2"], " ", 
            SuperscriptBox["c", "8"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["c", "10"]}]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"4", " ", 
      SuperscriptBox["a", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["b", "10"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "9"], " ", "c"}], "+", 
        RowBox[{"4", " ", "a", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "5"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "a"}], "-", 
           RowBox[{"2", " ", "c"}]}], ")"}], " ", 
         SuperscriptBox["c", "6"]}], "+", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "a"}], "-", 
           RowBox[{"2", " ", "c"}]}], ")"}], " ", 
         SuperscriptBox["c", "7"]}], "+", 
        RowBox[{"2", " ", "b", " ", 
         SuperscriptBox["c", "8"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", "a"}], "+", 
           RowBox[{"2", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "9"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"5", " ", "a"}], "+", 
           RowBox[{"2", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "8"], " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "a"}], "+", 
           RowBox[{"3", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "7"], " ", 
         SuperscriptBox["c", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "a"}], "+", 
           RowBox[{"3", " ", "c"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"17", " ", "a"}], "+", 
           RowBox[{"9", " ", "c"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "5"], " ", 
         SuperscriptBox["c", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"17", " ", "a"}], "+", 
           RowBox[{"9", " ", "c"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"4", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["b", "14"]}], "-", 
        RowBox[{"3", " ", 
         SuperscriptBox["b", "12"], " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "a"}], "+", 
           RowBox[{"5", " ", "c"}]}], ")"}]}], "-", 
        RowBox[{"5", " ", 
         SuperscriptBox["b", "8"], " ", 
         SuperscriptBox["c", "5"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"8", " ", "a"}], "+", 
           RowBox[{"5", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{"10", " ", 
         SuperscriptBox["b", "4"], " ", 
         SuperscriptBox["c", "9"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", "a"}], "+", 
           RowBox[{"7", " ", "c"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "6"], " ", 
         SuperscriptBox["c", "7"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"6", " ", "a"}], "+", 
           RowBox[{"11", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "13"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"75", " ", "a"}], "+", 
           RowBox[{"31", " ", "c"}]}], ")"}]}], "+", 
        RowBox[{
         SuperscriptBox["b", "10"], " ", 
         SuperscriptBox["c", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"31", " ", "a"}], "+", 
           RowBox[{"34", " ", "c"}]}], ")"}]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", 
         SuperscriptBox["c", "11"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"157", " ", "a"}], "+", 
           RowBox[{"117", " ", "c"}]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "4"], " ", 
      SuperscriptBox["c", "6"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", "a", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "+", 
        SuperscriptBox["b", "4"], "+", 
        SuperscriptBox["c", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "+", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      SuperscriptBox["b", "5"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"]}], "-", 
        RowBox[{"2", " ", "c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["a", "4"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["a", "2"], " ", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           SuperscriptBox["b", "2"], "-", 
           SuperscriptBox["c", "2"]}], ")"}], "2"]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "4"}], " ", 
      SuperscriptBox["c", "6"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"5", " ", "a", " ", 
         SuperscriptBox["c", "2"]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "3"]}]}], ")"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.947496586782467*^9, 3.947497917409426*^9, {3.94749917182654*^9, 
   3.947499188445355*^9}, 3.947587039348997*^9},
 CellLabel->
  "Out[225]=",ExpressionUUID->"2467c770-6fb9-4d41-b615-210be476d1f1"]
}, Open  ]],

Cell["persp[ABCD, HGFE]", "Subsubsection",
 CellChangeTimes->{{3.946480958971756*^9, 3.9464809648964844`*^9}, {
  3.9475870430433865`*^9, 
  3.9475870456113205`*^9}},ExpressionUUID->"58f6463e-c4e0-2141-8cdb-\
a9f17d56ad1d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"PerspectiveQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptH", ",", "ptG", ",", "ptF", ",", "ptE"}], "}"}]}], "]"}], 
   ",", "bitrap"}], "]"}]], "Input",
 CellChangeTimes->{{3.946484375956259*^9, 3.946484388812689*^9}, {
  3.946484743732359*^9, 3.946484745051697*^9}, {3.946484944236145*^9, 
  3.946484944315735*^9}, {3.9474965839636345`*^9, 3.947496591649502*^9}, {
  3.9474991946854057`*^9, 3.947499200844036*^9}},
 CellLabel->
  "In[226]:=",ExpressionUUID->"42efac62-03fd-b440-bc9d-155b84d49ce7"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{
  3.946484389862408*^9, 3.9464847461500416`*^9, 3.946484945088333*^9, 
   3.94654603179298*^9, 3.947496600502594*^9, 3.9474979216580315`*^9, {
   3.947499191417513*^9, 3.9474992018323183`*^9}, 3.947587047067068*^9},
 CellLabel->
  "Out[226]=",ExpressionUUID->"80a1cf50-79d8-9a4b-8c48-00a9948f26d1"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["X (999) ", "Subsection",
 CellChangeTimes->{{3.94647886735042*^9, 3.946478870724262*^9}, {
   3.946484241605079*^9, 3.946484242732435*^9}, 3.946545890008735*^9, 
   3.9474958102187634`*^9},ExpressionUUID->"5bdbc0fd-faa7-7b49-a9ff-\
f9c7216c0204"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"ptE", ",", "ptF", ",", "ptG", ",", "ptH"}], "}"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"CentralQuadrilateral", "[", "999", "]"}], ",", "bitrap"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.947496422113624*^9, 3.947496437002133*^9}},
 CellLabel->
  "In[227]:=",ExpressionUUID->"025d6a39-4e54-ab44-af69-ce05e9109a97"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"2", " ", "b", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "b", " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", 
        RowBox[{"2", " ", "c"}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"4", " ", "a", " ", 
       SuperscriptBox["b", "2"], " ", "c"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["b", "3"], " ", "c"}], "-", 
      RowBox[{"2", " ", "a", " ", 
       SuperscriptBox["c", "3"]}], "-", 
      RowBox[{"4", " ", "b", " ", 
       SuperscriptBox["c", "3"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", "c"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "-", 
        RowBox[{"3", " ", "a", " ", "b", " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "3"], "-", 
         RowBox[{"b", " ", 
          SuperscriptBox["c", "2"]}]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"3", " ", "a"}], "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "c", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["b", "2"], "-", 
         SuperscriptBox["c", "2"]}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         SuperscriptBox["b", "3"]}], "+", 
        RowBox[{"2", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"a", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SuperscriptBox["b", "2"]}], "+", 
           RowBox[{"4", " ", "b", " ", "c"}], "-", 
           SuperscriptBox["c", "2"]}], ")"}]}]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "2"}], " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"b", "-", "c"}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"b", "+", "c"}], ")"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "-", 
        RowBox[{"3", " ", "a", " ", "b", " ", "c"}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["c", "2"]}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "b", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "3"], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        RowBox[{"2", " ", 
         SuperscriptBox["c", "3"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "-", 
        RowBox[{"c", " ", 
         RowBox[{"(", 
          RowBox[{"a", "+", "c"}], ")"}]}]}], ")"}]}], ",", 
     RowBox[{
      RowBox[{"-", "2"}], " ", "a", " ", 
      SuperscriptBox["c", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        SuperscriptBox["c", "2"]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         SuperscriptBox["b", "3"]}], "-", 
        RowBox[{
         SuperscriptBox["b", "2"], " ", "c"}], "-", 
        RowBox[{"2", " ", "b", " ", 
         SuperscriptBox["c", "2"]}], "+", 
        SuperscriptBox["c", "3"]}], ")"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"2", " ", 
      SuperscriptBox["a", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["b", "2"]}], "+", 
        RowBox[{"a", " ", "c"}], "+", 
        RowBox[{"2", " ", "b", " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"2", " ", 
      SuperscriptBox["b", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["b", "2"], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"a", "-", "c"}], ")"}], " ", "c"}]}], ")"}]}], ",", 
     RowBox[{"2", " ", "a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "b"}], "-", "c"}], ")"}], " ", 
      SuperscriptBox["c", "2"]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.9474964227877636`*^9, 3.947496438197365*^9}, 
   3.9475870834356556`*^9},
 CellLabel->
  "Out[227]=",ExpressionUUID->"a858a9c7-a282-fe4d-ae89-139718a85469"]
}, Open  ]],

Cell["persp[ABCD, GHEF]", "Subsubsection",
 CellChangeTimes->{{3.946480913979744*^9, 3.946480925928507*^9}, {
  3.9475870857874165`*^9, 
  3.9475870885384636`*^9}},ExpressionUUID->"60c038d5-e73d-7f49-b07d-\
f95d9692bb5b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"PerspectiveQ", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ptA", ",", "ptB", ",", "ptC", ",", "ptD"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ptG", ",", "ptH", ",", "ptE", ",", "ptF"}], "}"}]}], "]"}], 
   ",", "bitrap"}], "]"}]], "Input",
 CellChangeTimes->{{3.9464841669171715`*^9, 3.946484167565193*^9}, {
  3.946484222052929*^9, 3.946484222509243*^9}, {3.946545877968584*^9, 
  3.946545884312385*^9}, {3.9474964200349045`*^9, 3.947496440937083*^9}},
 CellLabel->
  "In[228]:=",ExpressionUUID->"a3722d35-a74f-dc40-a333-9257da25d389"],

Cell[BoxData["True"], "Output",
 CellChangeTimes->{3.9464842235813007`*^9, 3.9465458852839565`*^9, 
  3.9465523721132183`*^9, 3.9465524585745754`*^9, 3.947496441480583*^9, 
  3.947587090468443*^9},
 CellLabel->
  "Out[228]=",ExpressionUUID->"51e33f68-dd3a-cd47-99a4-2f3d84f6486b"]
}, Open  ]]
}, Closed]]
}, Closed]]
},
CellGrouping->Manual,
WindowSize->{1293.2830188679245`, 654.7924528301886},
WindowMargins->{{0, Automatic}, {Automatic, -0.6792452830188679}},
FrontEndVersion->"14.0 for Microsoft Windows (64-bit) (December 12, 2023)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"80ca21bd-e8ad-6048-9d4a-0e43d47d3f1c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 385, 6, 98, "Title",ExpressionUUID->"29001ab6-6556-7b4b-a45f-7ca429ca0ceb"],
Cell[946, 28, 1504, 25, 173, "Text",ExpressionUUID->"08758b0a-705f-b842-b1d6-6a28a79b6218"],
Cell[CellGroupData[{
Cell[2475, 57, 200, 4, 67, "Section",ExpressionUUID->"5e4c6aa2-710c-4599-941e-5f13e499af78"],
Cell[2678, 63, 1322, 28, 48, "Input",ExpressionUUID->"0ab55ca4-7597-488a-96c3-e391e6fbeef1"],
Cell[CellGroupData[{
Cell[4025, 95, 268, 7, 28, "Input",ExpressionUUID->"f08a65d6-2a9b-5346-8b33-49696673696b"],
Cell[4296, 104, 549, 17, 35, "Output",ExpressionUUID->"062b5b80-f103-7c4f-ac50-c589f2f202c5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4882, 126, 816, 23, 67, "Input",ExpressionUUID->"e93692f2-d74e-9345-bba6-3ddc32f5e013"],
Cell[5701, 151, 1167, 35, 35, "Output",ExpressionUUID->"221f3288-9f9f-cc48-8020-2043eec504ff"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6905, 191, 741, 21, 28, "Input",ExpressionUUID->"032fb70e-8218-4041-b370-2b5bda03807a"],
Cell[7649, 214, 741, 23, 53, "Output",ExpressionUUID->"78c19a84-1ce3-f443-841c-9f1a0fd48399"]
}, Open  ]],
Cell[8405, 240, 1474, 45, 50, "Input",ExpressionUUID->"d865d4d2-1c7e-a94b-bb8d-af4ca1b1133d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9916, 290, 255, 4, 67, "Section",ExpressionUUID->"cf60f297-bbcd-8748-b453-e7118b4e0a98"],
Cell[CellGroupData[{
Cell[10196, 298, 212, 4, 54, "Subsection",ExpressionUUID->"c8cca55e-04f1-8f4a-b670-3c3179eed91e"],
Cell[10411, 304, 271227, 7063, 3643, "Input",ExpressionUUID->"90297db1-2eea-6346-9338-a3e8dcfe0024"]
}, Closed]],
Cell[CellGroupData[{
Cell[281675, 7372, 215, 4, 38, "Subsection",ExpressionUUID->"79ef6085-3de7-3c49-8561-f943fbd2d431"],
Cell[281893, 7378, 438, 12, 28, "Input",ExpressionUUID->"e725b315-4161-274c-8798-a4e0c807d6a8"],
Cell[282334, 7392, 439, 12, 28, "Input",ExpressionUUID->"60fea3de-a36e-734d-b67f-75eab8f36838"],
Cell[282776, 7406, 438, 12, 28, "Input",ExpressionUUID->"422bd8e2-a85e-d748-b542-6c9b62c11efd"],
Cell[283217, 7420, 1082, 30, 28, "Input",ExpressionUUID->"d021f1ab-c58d-b74b-8aa5-a62365464cc5"],
Cell[284302, 7452, 820, 24, 28, "Input",ExpressionUUID->"023d4850-e194-b941-a762-4c9a532e11d1"],
Cell[285125, 7478, 603, 17, 28, "Input",ExpressionUUID->"62ef2468-c328-714d-8bf7-299b142a086d"],
Cell[285731, 7497, 2073, 54, 181, "Input",ExpressionUUID->"d734f707-6812-364b-b359-ac3a6bb66e72"],
Cell[287807, 7553, 1714, 47, 143, "Input",ExpressionUUID->"34f7e383-98aa-bc47-9867-166186424dd4"],
Cell[289524, 7602, 1914, 51, 162, "Input",ExpressionUUID->"4370c731-693f-a941-82c8-1f6a14f724b2"],
Cell[291441, 7655, 613, 17, 28, "Input",ExpressionUUID->"6e2024d9-4541-ea4e-a308-49a8bb9b87a5"],
Cell[292057, 7674, 1131, 30, 124, "Input",ExpressionUUID->"384fc915-4ebd-5342-9174-a166a5e7f52d"],
Cell[293191, 7706, 1395, 40, 124, "Input",ExpressionUUID->"e878baba-ea71-dd4f-b972-2e4c3753c774"],
Cell[294589, 7748, 1398, 40, 124, "Input",ExpressionUUID->"4200ee2b-abeb-b246-85fa-68f1ce5d836b"],
Cell[295990, 7790, 1330, 39, 124, "Input",ExpressionUUID->"8131db8a-5012-e741-93f3-ec6da52923f1"],
Cell[297323, 7831, 1368, 38, 143, "Input",ExpressionUUID->"3e5eb206-464c-7e4f-b628-98c50c5a4629"]
}, Closed]],
Cell[CellGroupData[{
Cell[298728, 7874, 291, 5, 38, "Subsection",ExpressionUUID->"d004e03f-8f12-9a43-865f-339812029417"],
Cell[299022, 7881, 3318, 101, 130, "Input",ExpressionUUID->"059a14ad-548f-1d43-b181-7239fd1e5301"]
}, Closed]],
Cell[CellGroupData[{
Cell[302377, 7987, 170, 3, 38, "Subsection",ExpressionUUID->"2a49be25-3c4e-430e-86c6-869880736f30"],
Cell[CellGroupData[{
Cell[302572, 7994, 217, 4, 45, "Subsubsection",ExpressionUUID->"a576f9af-1f5b-4213-b4d3-e7b66981337e"],
Cell[302792, 8000, 53880, 889, 404, "Text",ExpressionUUID->"f7950398-57cb-4ee6-bf14-597b39eb91df"],
Cell[356675, 8891, 999, 25, 86, "Input",ExpressionUUID->"cf738f77-0d96-4e62-81a0-f2a504594dc8"]
}, Closed]],
Cell[CellGroupData[{
Cell[357711, 8921, 238, 4, 37, "Subsubsection",ExpressionUUID->"f7957972-a4e9-446f-bafd-6774f0dd3699"],
Cell[357952, 8927, 817, 19, 48, "Input",ExpressionUUID->"44de57fd-6e7d-4d98-94a0-c7b93947eadd"]
}, Closed]],
Cell[CellGroupData[{
Cell[358806, 8951, 215, 4, 37, "Subsubsection",ExpressionUUID->"ae32c2db-9871-344f-aabd-a2543db56100"],
Cell[359024, 8957, 2076, 57, 101, "Input",ExpressionUUID->"db0fcba9-9144-4df7-981b-db22bb466a6e"]
}, Closed]],
Cell[CellGroupData[{
Cell[361137, 9019, 242, 4, 37, "Subsubsection",ExpressionUUID->"29f12ada-9fd0-4747-b323-2cf96d6fb52e"],
Cell[361382, 9025, 664, 16, 28, "Input",ExpressionUUID->"158fb412-c771-43ab-b43b-a357380f4a11"]
}, Closed]],
Cell[CellGroupData[{
Cell[362083, 9046, 197, 3, 37, "Subsubsection",ExpressionUUID->"5a543829-5641-9144-8dd0-57eb7cf1938d"],
Cell[362283, 9051, 1567, 43, 124, "Input",ExpressionUUID->"35cb8ff3-829e-654a-a95d-e2c972de6be9"]
}, Closed]],
Cell[CellGroupData[{
Cell[363887, 9099, 174, 3, 37, "Subsubsection",ExpressionUUID->"e039afe9-d89d-4ec4-94b9-ddb3f9f259e0"],
Cell[364064, 9104, 562, 15, 28, "Input",ExpressionUUID->"2db3c5dc-e4da-4371-937a-22cb108c81e1"]
}, Closed]],
Cell[CellGroupData[{
Cell[364663, 9124, 372, 6, 37, "Subsubsection",ExpressionUUID->"bd16b166-d506-5544-b5d0-7aa6edfca35b"],
Cell[365038, 9132, 1247, 34, 52, "Input",ExpressionUUID->"6cd12b17-ccf6-1f40-8216-e746f72a898c"]
}, Closed]],
Cell[CellGroupData[{
Cell[366322, 9171, 384, 6, 37, "Subsubsection",ExpressionUUID->"d546f79d-5ed9-4f99-846e-3ac1a3756b86"],
Cell[366709, 9179, 972, 27, 28, "Input",ExpressionUUID->"5668c7c2-b2f3-48b4-bb4e-3f493e46ab9c"],
Cell[367684, 9208, 883, 25, 28, "Input",ExpressionUUID->"d07dfa48-d9b6-433c-9d4d-8f2532f1bec3"]
}, Closed]],
Cell[CellGroupData[{
Cell[368604, 9238, 323, 5, 37, "Subsubsection",ExpressionUUID->"8f461d45-0647-c84b-9fe0-f72d3601c63f"],
Cell[368930, 9245, 1686, 41, 157, "Input",ExpressionUUID->"5485ed32-34f6-e64e-bd2a-b4e163c2b97f"]
}, Closed]],
Cell[CellGroupData[{
Cell[370653, 9291, 201, 3, 35, "Subsubsection",ExpressionUUID->"54169a90-c35c-7a4a-a37f-78c9753e8eeb"],
Cell[370857, 9296, 1631, 40, 124, "Input",ExpressionUUID->"c1bc4c8d-1ecd-654a-b9e2-f902b4037dfa"]
}, Closed]],
Cell[CellGroupData[{
Cell[372525, 9341, 225, 4, 35, "Subsubsection",ExpressionUUID->"e126572d-bdab-a047-b925-c2661290f09e"],
Cell[372753, 9347, 1442, 38, 105, "Input",ExpressionUUID->"3eac6f83-9820-5d4f-9acd-4f2df1b13510"]
}, Closed]],
Cell[CellGroupData[{
Cell[374232, 9390, 308, 5, 35, "Subsubsection",ExpressionUUID->"1d12da59-37f1-9842-ad9c-eb916041816f"],
Cell[374543, 9397, 3090, 71, 219, "Input",ExpressionUUID->"806c98e7-c027-de46-8fc2-cc2eda959f64"]
}, Closed]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[377694, 9475, 211, 4, 53, "Section",ExpressionUUID->"2609bf4c-7f5c-314e-a744-f86d4be283dd"],
Cell[377908, 9481, 48556, 801, 192, "Text",ExpressionUUID->"6edcdd0e-574a-514a-a312-cbd371c30c4a"],
Cell[CellGroupData[{
Cell[426489, 10286, 251, 4, 54, "Subsection",ExpressionUUID->"c173dcb1-febd-9a4a-b5af-dfde8ba19c65"],
Cell[CellGroupData[{
Cell[426765, 10294, 297, 7, 28, "Input",ExpressionUUID->"4a5eadcd-c916-b942-b1b2-20d539b7d941"],
Cell[427065, 10303, 7865, 246, 100, "Output",ExpressionUUID->"74d2b946-6d7c-be44-80a1-0ae151991ff8"]
}, Open  ]],
Cell[434945, 10552, 221, 4, 45, "Subsubsection",ExpressionUUID->"84514861-48cf-354f-a1d8-2fa86e35ac09"],
Cell[CellGroupData[{
Cell[435191, 10560, 568, 14, 24, "Input",ExpressionUUID->"94388c6d-da73-be45-bb48-9f9ffc9dee06"],
Cell[435762, 10576, 375, 7, 32, "Output",ExpressionUUID->"929ff6ae-3e71-244c-b4ad-da783ef8c668"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[436186, 10589, 205, 4, 38, "Subsection",ExpressionUUID->"d03feb85-5ec7-6843-823f-d6dddf7c9b44"],
Cell[CellGroupData[{
Cell[436416, 10597, 297, 7, 28, "Input",ExpressionUUID->"b5eedecd-d41c-4544-bfc5-f26ed8ef2138"],
Cell[436716, 10606, 12467, 393, 143, "Output",ExpressionUUID->"1fc79ffb-7c3c-724b-a006-410924e36a66"]
}, Open  ]],
Cell[449198, 11002, 219, 4, 45, "Subsubsection",ExpressionUUID->"44c4fbe4-3b25-2b44-b3f9-05b92e35c416"],
Cell[CellGroupData[{
Cell[449442, 11010, 540, 12, 24, "Input",ExpressionUUID->"d94e020f-2e70-2e4d-888b-7ce993a9645c"],
Cell[449985, 11024, 275, 5, 32, "Output",ExpressionUUID->"af38611f-7522-424f-8894-2d5f28c93789"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[450309, 11035, 279, 5, 38, "Subsection",ExpressionUUID->"ea27e41e-d504-114f-a97f-3cc630e1f51a"],
Cell[CellGroupData[{
Cell[450613, 11044, 299, 7, 28, "Input",ExpressionUUID->"bc34a32f-184f-cf4f-98f0-e85293ab587a"],
Cell[450915, 11053, 5157, 166, 100, "Output",ExpressionUUID->"1ad02fdd-360e-f347-a6cd-b3de99da69ec"]
}, Open  ]],
Cell[456087, 11222, 217, 4, 45, "Subsubsection",ExpressionUUID->"6868747d-3f40-1649-83f9-05a3d48fd7c7"],
Cell[CellGroupData[{
Cell[456329, 11230, 573, 14, 24, "Input",ExpressionUUID->"a5633397-214a-064e-9ebb-5e94978088ef"],
Cell[456905, 11246, 295, 5, 32, "Output",ExpressionUUID->"8d81fe1b-0248-924e-830a-9b5297a841a1"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[457249, 11257, 325, 5, 38, "Subsection",ExpressionUUID->"8162f58e-cebe-8b42-addc-616c9668dd6c"],
Cell[CellGroupData[{
Cell[457599, 11266, 415, 11, 28, "Input",ExpressionUUID->"fe97a52c-c48d-3745-9e74-2c33e1bf096c"],
Cell[458017, 11279, 4924, 155, 100, "Output",ExpressionUUID->"a9a986b7-fd80-7048-95c3-c65e091bcad9"]
}, Open  ]],
Cell[462956, 11437, 221, 4, 45, "Subsubsection",ExpressionUUID->"5600e1d2-219e-9e47-a2eb-208e4df03122"],
Cell[CellGroupData[{
Cell[463202, 11445, 619, 14, 24, "Input",ExpressionUUID->"c93c069f-e9a0-7843-b3bc-1f354e62ef44"],
Cell[463824, 11461, 320, 5, 32, "Output",ExpressionUUID->"0aa77088-61ce-2e40-8d87-a9d2a34036d1"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[464193, 11472, 301, 5, 38, "Subsection",ExpressionUUID->"ecf41c4d-6006-3e4b-8cb1-077ce99b635c"],
Cell[CellGroupData[{
Cell[464519, 11481, 420, 11, 28, "Input",ExpressionUUID->"6c96383e-9bad-db40-85c9-29e76a67c9ac"],
Cell[464942, 11494, 4812, 154, 78, "Output",ExpressionUUID->"48df5f7d-c3de-7947-9ecd-16a0f50864b9"]
}, Open  ]],
Cell[469769, 11651, 221, 4, 45, "Subsubsection",ExpressionUUID->"b3578f1b-396a-4f49-8b3e-8a7cf8232f5a"],
Cell[CellGroupData[{
Cell[470015, 11659, 664, 15, 24, "Input",ExpressionUUID->"d8ec441d-459e-5046-a6d0-3df636bb103d"],
Cell[470682, 11676, 326, 6, 32, "Output",ExpressionUUID->"31a058dc-057a-3a41-9e00-de1a9805b172"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[471057, 11688, 300, 5, 38, "Subsection",ExpressionUUID->"25ffaade-b49d-bd48-ad38-0be379197bbe"],
Cell[CellGroupData[{
Cell[471382, 11697, 415, 11, 28, "Input",ExpressionUUID->"57da1e63-ed71-254a-812b-9649f0307946"],
Cell[471800, 11710, 8240, 255, 122, "Output",ExpressionUUID->"7970a562-4d3d-d241-892e-1aada7df8460"]
}, Open  ]],
Cell[480055, 11968, 219, 4, 45, "Subsubsection",ExpressionUUID->"ccd0a6e1-05a2-8640-aea4-20d6bab04ca6"],
Cell[CellGroupData[{
Cell[480299, 11976, 664, 15, 24, "Input",ExpressionUUID->"715a8371-20a1-3348-a675-8de265d70a8b"],
Cell[480966, 11993, 326, 6, 32, "Output",ExpressionUUID->"593d2162-7189-004b-a850-f3984719b8c3"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[481341, 12005, 253, 4, 38, "Subsection",ExpressionUUID->"353ebd32-2929-5b48-8c60-6cbc952596ea"],
Cell[CellGroupData[{
Cell[481619, 12013, 349, 8, 28, "Input",ExpressionUUID->"d5e08ff4-af4b-6e46-9893-b28f591f95f6"],
Cell[481971, 12023, 13148, 409, 143, "Output",ExpressionUUID->"a58c6b26-7591-774f-b83b-e5c135d1793d"]
}, Open  ]],
Cell[495134, 12435, 223, 4, 45, "Subsubsection",ExpressionUUID->"e94d0c2c-dee5-8846-a01e-bf8b42a5c175"],
Cell[CellGroupData[{
Cell[495382, 12443, 540, 12, 24, "Input",ExpressionUUID->"1f448385-8da4-b64a-bd7d-ed117554f4d9"],
Cell[495925, 12457, 295, 5, 32, "Output",ExpressionUUID->"a842f168-6e52-d44b-b0c6-e3b05193f487"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[496269, 12468, 322, 5, 38, "Subsection",ExpressionUUID->"26d63e37-acda-634b-912a-9b26c0fd603f"],
Cell[CellGroupData[{
Cell[496616, 12477, 394, 10, 28, "Input",ExpressionUUID->"e7f67593-6745-1a47-84b4-1f86c2355c73"],
Cell[497013, 12489, 4499, 142, 78, "Output",ExpressionUUID->"267fbcea-c65e-1247-b7f7-13614d1822d3"]
}, Open  ]],
Cell[501527, 12634, 216, 4, 45, "Subsubsection",ExpressionUUID->"6aa558f6-c645-004b-b224-c24abf383866"],
Cell[CellGroupData[{
Cell[501768, 12642, 615, 14, 24, "Input",ExpressionUUID->"a063d7ab-ebce-844e-ae0a-9297a16b02cd"],
Cell[502386, 12658, 278, 5, 32, "Output",ExpressionUUID->"5ff13691-eef0-654e-8fd6-2c4636160c05"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[502713, 12669, 332, 5, 38, "Subsection",ExpressionUUID->"bdc5cdc9-8746-324d-9b9d-c8d522ced518"],
Cell[CellGroupData[{
Cell[503070, 12678, 419, 11, 28, "Input",ExpressionUUID->"f0eaf5f7-f2af-434a-ba83-9b0a2c1f96df"],
Cell[503492, 12691, 17318, 536, 252, "Output",ExpressionUUID->"6ada0d69-d742-b64a-a4ad-20330c7ae2b7"]
}, Open  ]],
Cell[520825, 13230, 221, 4, 45, "Subsubsection",ExpressionUUID->"958d8a62-f0cb-854b-a30a-002c787d1863"],
Cell[CellGroupData[{
Cell[521071, 13238, 666, 15, 24, "Input",ExpressionUUID->"f06af811-0844-934e-b55e-a9cd57a4fa42"],
Cell[521740, 13255, 322, 6, 32, "Output",ExpressionUUID->"2b65a913-5bc3-924c-a65f-7fdc9d8b389e"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[522111, 13267, 302, 5, 38, "Subsection",ExpressionUUID->"a5b9d6f0-5337-474c-87dd-249e4f8834a8"],
Cell[CellGroupData[{
Cell[522438, 13276, 417, 11, 28, "Input",ExpressionUUID->"447a603a-a4e3-4540-b55c-fb04074ea1d7"],
Cell[522858, 13289, 5661, 176, 78, "Output",ExpressionUUID->"b1d428d9-cdff-0348-9d71-cf4f3787836b"]
}, Open  ]],
Cell[528534, 13468, 219, 4, 45, "Subsubsection",ExpressionUUID->"c2c5adb2-eab2-bf45-ad1a-9a670e6db80d"],
Cell[CellGroupData[{
Cell[528778, 13476, 664, 15, 24, "Input",ExpressionUUID->"2105c51b-b181-ae44-95e7-7b4bde0d1e37"],
Cell[529445, 13493, 350, 6, 32, "Output",ExpressionUUID->"5fbf4186-2143-934b-95de-50afdb08cd37"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[529844, 13505, 256, 4, 38, "Subsection",ExpressionUUID->"611c64c4-50b0-f446-b80f-43bf368bf2c6"],
Cell[CellGroupData[{
Cell[530125, 13513, 349, 8, 28, "Input",ExpressionUUID->"5789f6fa-53c5-1a4d-a44a-5cd8db562c48"],
Cell[530477, 13523, 6727, 214, 100, "Output",ExpressionUUID->"01948c3a-bc7b-cd49-8792-9cdea4826a15"]
}, Open  ]],
Cell[537219, 13740, 221, 4, 45, "Subsubsection",ExpressionUUID->"dcfab937-bfaa-a246-a446-61b1a490bf6b"],
Cell[CellGroupData[{
Cell[537465, 13748, 540, 12, 24, "Input",ExpressionUUID->"bea49425-a0b6-604f-8c87-195ac42b3bf9"],
Cell[538008, 13762, 299, 5, 32, "Output",ExpressionUUID->"aa93d1c4-dad5-ed42-b187-08022f45d39c"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[538356, 13773, 254, 4, 38, "Subsection",ExpressionUUID->"acfccc66-81e9-9b42-acc8-f7cd3d3f0c21"],
Cell[CellGroupData[{
Cell[538635, 13781, 349, 8, 28, "Input",ExpressionUUID->"a95f8b12-342b-194b-bc9a-da7c6800d0c6"],
Cell[538987, 13791, 14477, 435, 165, "Output",ExpressionUUID->"020cf8fb-a8ba-a141-a999-d45b56e45d24"]
}, Open  ]],
Cell[553479, 14229, 221, 4, 45, "Subsubsection",ExpressionUUID->"770dd665-cc10-7245-a242-3741a759ae7d"],
Cell[CellGroupData[{
Cell[553725, 14237, 540, 12, 24, "Input",ExpressionUUID->"9d2277a4-f0c9-504f-bfa7-ccb6cde2ad71"],
Cell[554268, 14251, 299, 5, 32, "Output",ExpressionUUID->"90a2ef84-a9cc-ed44-903a-eef04d45d317"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[554616, 14262, 354, 6, 38, "Subsection",ExpressionUUID->"34c17ba1-6ab0-3e42-9e67-0fe0854ddf0d"],
Cell[CellGroupData[{
Cell[554995, 14272, 421, 11, 28, "Input",ExpressionUUID->"57764ba9-1a85-c944-9db0-85a70fb248b1"],
Cell[555419, 14285, 19032, 563, 252, "Output",ExpressionUUID->"69ba714c-74bb-d149-97a1-78e88798d907"]
}, Open  ]],
Cell[574466, 14851, 221, 4, 45, "Subsubsection",ExpressionUUID->"606b6d1d-be84-5f4a-8d6f-bf7c89cb0668"],
Cell[CellGroupData[{
Cell[574712, 14859, 668, 15, 24, "Input",ExpressionUUID->"b9d481fb-186c-5744-a51a-2889d86fd1d1"],
Cell[575383, 14876, 349, 6, 32, "Output",ExpressionUUID->"b7b5c811-02ec-6f40-9a28-5fa9467aedc8"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[575781, 14888, 157, 3, 38, "Subsection",ExpressionUUID->"d23d7d1f-17b4-254e-a768-a6c16b5b2671"],
Cell[CellGroupData[{
Cell[575963, 14895, 298, 7, 28, "Input",ExpressionUUID->"d3da9c21-fac2-b449-a046-6e794cc9a19b"],
Cell[576264, 14904, 8337, 268, 100, "Output",ExpressionUUID->"d00cf80e-9936-7843-b6dc-f24429211d98"]
}, Open  ]],
Cell[584616, 15175, 193, 3, 45, "Subsubsection",ExpressionUUID->"c252966a-0cc9-6749-8a08-1eae86d04058"],
Cell[CellGroupData[{
Cell[584834, 15182, 446, 11, 24, "Input",ExpressionUUID->"f68b6529-731b-2e4f-9b5b-334ba7343e89"],
Cell[585283, 15195, 278, 5, 32, "Output",ExpressionUUID->"95581cfd-d846-0443-a0ac-3b393320ff2c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[585598, 15205, 340, 8, 48, "Input",ExpressionUUID->"13374f17-2f1d-8042-a0a7-87ac867f97a7"],
Cell[585941, 15215, 175, 4, 47, "Output",ExpressionUUID->"c8e37270-ed67-a047-810d-70091650c343"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[586165, 15225, 404, 6, 38, "Subsection",ExpressionUUID->"e9744ba1-7fd4-074f-a5a8-fb26516a8451"],
Cell[CellGroupData[{
Cell[586594, 15235, 468, 12, 28, "Input",ExpressionUUID->"8cafcb74-7d5b-bf44-914c-738ebce59c89"],
Cell[587065, 15249, 16445, 490, 208, "Output",ExpressionUUID->"2467c770-6fb9-4d41-b615-210be476d1f1"]
}, Open  ]],
Cell[603525, 15742, 223, 4, 45, "Subsubsection",ExpressionUUID->"58f6463e-c4e0-2141-8cdb-a9f17d56ad1d"],
Cell[CellGroupData[{
Cell[603773, 15750, 666, 15, 24, "Input",ExpressionUUID->"42efac62-03fd-b440-bc9d-155b84d49ce7"],
Cell[604442, 15767, 350, 6, 32, "Output",ExpressionUUID->"80a1cf50-79d8-9a4b-8c48-00a9948f26d1"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[604841, 15779, 252, 4, 38, "Subsection",ExpressionUUID->"5bdbc0fd-faa7-7b49-a9ff-f9c7216c0204"],
Cell[CellGroupData[{
Cell[605118, 15787, 392, 10, 28, "Input",ExpressionUUID->"025d6a39-4e54-ab44-af69-ce05e9109a97"],
Cell[605513, 15799, 5331, 165, 100, "Output",ExpressionUUID->"a858a9c7-a282-fe4d-ae89-139718a85469"]
}, Open  ]],
Cell[610859, 15967, 221, 4, 45, "Subsubsection",ExpressionUUID->"60c038d5-e73d-7f49-b07d-f95d9692bb5b"],
Cell[CellGroupData[{
Cell[611105, 15975, 617, 14, 24, "Input",ExpressionUUID->"a3722d35-a74f-dc40-a333-9257da25d389"],
Cell[611725, 15991, 280, 5, 32, "Output",ExpressionUUID->"51e33f68-dd3a-cd47-99a4-2f3d84f6486b"]
}, Open  ]]
}, Closed]]
}, Closed]]
}
]
*)

